/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import configuration.AbstractConfigSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesConfigSource
extends AbstractConfigSource {
    private static final Logger logger = Logger.getLogger((String)PropertiesConfigSource.class.getName());
    private static final String DEFAULT_PRIAM_PROPERTIES = "cvhadooputil.properties";
    private final Map<String, String> data = Maps.newConcurrentMap();
    private final String priamFile;

    public PropertiesConfigSource() {
        this.priamFile = Paths.get(System.getProperty("cvutil.config.file"), DEFAULT_PRIAM_PROPERTIES).toAbsolutePath().toString();
    }

    public PropertiesConfigSource(Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        this.priamFile = Paths.get(System.getProperty("cvutil.config.file"), DEFAULT_PRIAM_PROPERTIES).toAbsolutePath().toString();
        this.clone(properties);
    }

    @VisibleForTesting
    PropertiesConfigSource(String file) {
        this.priamFile = (String)Preconditions.checkNotNull((Object)file);
    }

    @Override
    public void intialize() {
        super.intialize();
        Properties properties = new Properties();
        logger.info((Object)" Priam file ");
        logger.info((Object)this.priamFile);
        try {
            File file = new File(this.priamFile);
            FileInputStream fis = null;
            if (file != null) {
                logger.info((Object)"here");
                fis = new FileInputStream(file);
                try {
                    properties.load(fis);
                    this.clone(properties);
                }
                catch (IOException e) {
                    logger.info((Object)"No Priam.properties. Ignore! Exception");
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"No Priam.properties. Ignore! NUll ");
        }
    }

    @Override
    public String get(String prop) {
        return this.data.get(prop);
    }

    @Override
    public void set(String key, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value can not be null for configurations.");
        this.data.put(key, value);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean contains(String prop) {
        return this.data.containsKey(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clone(Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Properties properties2 = properties;
        synchronized (properties2) {
            for (String key : properties.stringPropertyNames()) {
                logger.info((Object)("Key found " + key));
                String value = properties.getProperty(key);
                if (Strings.isNullOrEmpty((String)value)) continue;
                this.data.put(key, value);
            }
        }
    }
}

