/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import configuration.IConfigSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractConfigSource
implements IConfigSource {
    @Override
    public void intialize() {
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean get(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Class<?> get(String key, Class<?> defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public <T extends Enum<T>> T get(String key, T defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Enum.valueOf(defaultValue.getDeclaringClass(), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int get(String key, int defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public long get(String key, long defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public float get(String key, float defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public double get(String key, double defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public List<String> getList(String prop) {
        return this.getList(prop, (List<String>)ImmutableList.of());
    }

    @Override
    public List<String> getList(String prop, List<String> defaultValue) {
        String value = this.get(prop);
        if (value != null) {
            return this.getTrimmedStringList(value.split(","));
        }
        return defaultValue;
    }

    private List<String> getTrimmedStringList(String[] strings) {
        ArrayList list = Lists.newArrayList();
        for (String s : strings) {
            list.add(StringUtils.strip((String)s));
        }
        return list;
    }
}

