/*
 * Decompiled with CFR 0.152.
 */
package com.github.gbraccialli.hdfs;

import com.github.gbraccialli.hdfs.HDFSConfigUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class RackDistrubtionUtil {
    private static FileSystem hdfs;
    private static Logger log;
    private static BufferedWriter statsFile;

    public static void main(String[] args) throws Exception {
        String confDir = "/etc/hadoop/conf";
        String path = "/";
        int maxLevelThreshold = -1;
        long minSizeThreshold = -1L;
        boolean showFiles = true;
        boolean verbose = false;
        String doAs = "hdfs";
        String collectFilePath = "";
        String hdfsURI = "hdfs:///";
        HashMap<String, BufferedWriter> writersBlock = new HashMap<String, BufferedWriter>();
        for (String arg : args) {
            if (arg.startsWith("--confDir=")) {
                confDir = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--path=")) {
                path = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--maxLevelThreshold=")) {
                maxLevelThreshold = Integer.parseInt(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--minSizeThreshold=")) {
                minSizeThreshold = Long.parseLong(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--showFiles=")) {
                showFiles = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--verbose=")) {
                verbose = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--collectFilePath=")) {
                collectFilePath = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--hdfsURI=")) {
                hdfsURI = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--doAs=")) {
                doAs = arg.split("=")[1];
                continue;
            }
            log.info((Object)("Argumment not in list of valid arguments, it will be ignored:" + arg));
        }
        System.setProperty("HADOOP_USER_NAME", doAs);
        hdfs = HDFSConfigUtils.loadConfigsAndGetFileSystem(confDir, doAs);
        File directory = new File(collectFilePath);
        String StatFileName = collectFilePath.concat("stat.cvf");
        FileWriter StatFileWriter = new FileWriter(StatFileName);
        statsFile = new BufferedWriter(StatFileWriter);
        File[] files = directory.listFiles();
        String pattern = "CollectTot[0-9]+.cvf";
        RegexFileFilter filter = new RegexFileFilter(pattern);
        files = directory.listFiles((FileFilter)filter);
        for (File file : files) {
            FileReader fileReader = new FileReader(file.getPath());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String collectFileEntry = "";
            while ((collectFileEntry = bufferedReader.readLine()) != null) {
                if (collectFileEntry.endsWith("/") || collectFileEntry.contains("%SCFILES%")) continue;
                Path path1 = new Path(collectFileEntry);
                String RackID = RackDistrubtionUtil.getRackForGivenFile(path1);
                if (writersBlock.containsKey(RackID)) {
                    log.debug((Object)("Writing into file " + RackID + " File: " + path1.getParent() + "/" + path1.getName()));
                    ((BufferedWriter)writersBlock.get(RackID)).write(collectFileEntry);
                    ((BufferedWriter)writersBlock.get(RackID)).newLine();
                    ((BufferedWriter)writersBlock.get(RackID)).flush();
                    continue;
                }
                String FileName = collectFilePath.concat(RackID + ".cvf");
                log.debug((Object)("Rack file name: " + FileName));
                FileWriter fWriter = new FileWriter(FileName);
                BufferedWriter writer = new BufferedWriter(fWriter);
                writersBlock.put(RackID, writer);
                ((BufferedWriter)writersBlock.get(RackID)).write(collectFileEntry);
                ((BufferedWriter)writersBlock.get(RackID)).newLine();
                ((BufferedWriter)writersBlock.get(RackID)).flush();
            }
            bufferedReader.close();
        }
        statsFile.close();
        for (BufferedWriter writer : writersBlock.values()) {
            writer.close();
        }
    }

    private static String getRackForGivenFile(Path path) throws IOException {
        long size = 0L;
        try {
            FileStatus fileStatus = hdfs.getFileStatus(path);
            size = fileStatus.getLen();
            if (fileStatus.isDirectory()) {
                return "Directory";
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File not found :" + e.getMessage()));
            return "/Corrupt";
        }
        BlockLocation[] blk = hdfs.getFileBlockLocations(path, 0L, size);
        HashMap<String, Long> sizeMap = new HashMap<String, Long>();
        String ReturnLoc = "";
        log.debug((Object)(" Path: " + path.getParent() + "/" + path.getName()));
        for (BlockLocation block : blk) {
            if (block.isCorrupt()) {
                return "/Corrupt";
            }
            log.debug((Object)("Getting block location [" + Arrays.toString(block.getHosts()) + "]  [" + Arrays.toString(block.getNames()) + "} [" + Arrays.deepToString(block.getTopologyPaths()) + " }"));
            log.debug((Object)(block.getOffset() + " " + block.getLength()));
            for (String blockLoc : block.getTopologyPaths()) {
                if (sizeMap.containsKey(blockLoc)) {
                    sizeMap.put(blockLoc, (Long)sizeMap.get(blockLoc) + block.getLength());
                    continue;
                }
                sizeMap.put(blockLoc, block.getLength());
            }
        }
        Long BiggestValue = new Long(0L);
        String statEntry = path.getParent() + "/" + path.getName() + " " + size;
        for (Map.Entry vals : sizeMap.entrySet()) {
            statEntry = statEntry.concat(" " + (String)vals.getKey() + ":" + vals.getValue());
            log.debug((Object)("Rack: " + (String)vals.getKey() + " Size:" + vals.getValue()));
            if (BiggestValue >= (Long)vals.getValue()) continue;
            ReturnLoc = (String)vals.getKey();
            BiggestValue = (Long)vals.getValue();
        }
        statsFile.write(statEntry);
        statsFile.newLine();
        if (BiggestValue < size * 2L / 3L) {
            log.error((Object)("Distribution size is less than 75% of file size Rack [" + ReturnLoc + "] Size on Rack: [" + BiggestValue + "] Actual Size [" + size + "]"));
        }
        if (ReturnLoc.isEmpty()) {
            ReturnLoc = "/default";
        }
        ReturnLoc = "/" + ReturnLoc.split("/")[1];
        return ReturnLoc;
    }

    static {
        log = Logger.getLogger(RackDistrubtionUtil.class);
    }
}

