/*
 * Decompiled with CFR 0.152.
 */
package com.github.gbraccialli.hdfs;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import util.KerberosUtil;
import util.StackTraceUtil;

public class HDFSConfigUtils {
    private static Logger log = Logger.getLogger(HDFSConfigUtils.class);
    private static final String[] HADOOP_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml"};
    private static final String[] principal_strings = new String[]{"dfs.permissions.superusergroup", "dfs.namenode.kerberos.principal"};

    public static FileSystem loadConfigsAndGetFileSystem(String hadoopConfDirProp) throws Exception {
        return HDFSConfigUtils.loadConfigsAndGetFileSystem(hadoopConfDirProp, null, null);
    }

    public static FileSystem loadConfigsAndGetFileSystem(String hadoopConfDirProp, String doAs) throws Exception {
        return HDFSConfigUtils.loadConfigsAndGetFileSystem(hadoopConfDirProp, null, doAs);
    }

    public static FileSystem loadConfigsAndGetFileSystem(String hadoopConfDirProp, String uri, String doAs) throws Exception {
        return HDFSConfigUtils.loadConfigsAndGetFileSystem(hadoopConfDirProp, uri, doAs, "");
    }

    public static FileSystem loadConfigsAndGetFileSystem(String hadoopConfDirProp, String uri, String doAs, String kerberosTicket) throws Exception {
        Configuration config;
        if (doAs == null) {
            doAs = "hdfs";
        }
        if (doAs != null && System.getProperty("HADOOP_USER_NAME") == null) {
            System.setProperty("HADOOP_USER_NAME", doAs);
        }
        log.info((Object)System.getProperty("HADOOP_USER_NAME"));
        if (hadoopConfDirProp == null) {
            hadoopConfDirProp = "/etc/hadoop/conf";
        }
        if ((config = new Configuration(false)).get("dfs.namenode.accesstime.precision") == null || config.get("dfs.namenode.accesstime.precision").isEmpty()) {
            config.setInt("dfs.namenode.accesstime.precision", 3600);
        }
        File hadoopConfDir = new File(hadoopConfDirProp).getAbsoluteFile();
        for (String file : HADOOP_CONF_FILES) {
            File f = new File(hadoopConfDir, file);
            if (!f.exists()) continue;
            config.addResource(new Path(f.getAbsolutePath()));
        }
        try {
            FileSystem hdfs;
            if (config.get("hadoop.security.authentication") != null && config.get("hadoop.security.authentication").compareToIgnoreCase(new String("kerberos")) == 0) {
                log.info((Object)"Kerberos Auth detected");
                config.set("dfs.namenode.kerberos.principal.pattern", config.get("dfs.namenode.kerberos.principal").replace("_HOST", "*"));
                config.set("dfs.client.use.datanode.hostname", "true");
                UserGroupInformation.setConfiguration((Configuration)config);
                if (Strings.isNullOrEmpty((String)kerberosTicket)) {
                    try {
                        log.info((Object)("Try default Username: " + doAs));
                        KerberosUtil.Login(doAs, config.get("hadoop.user.keytab.file"), config);
                    }
                    catch (Exception exp) {
                        log.info((Object)StackTraceUtil.getStackTrace(exp));
                        log.info((Object)"Try to identify the user with config files");
                        KerberosUtil.Login(principal_strings, config.get("hadoop.user.keytab.file"), config);
                    }
                    hdfs = FileSystem.get((Configuration)config);
                } else {
                    log.info((Object)("Create connection using already existing ticket: " + kerberosTicket));
                    config.set("hadoop.security.kerberos.ticket.cache.path", kerberosTicket);
                    hdfs = FileSystem.newInstance((Configuration)config);
                }
            } else {
                hdfs = uri != null && uri.length() > 0 ? FileSystem.get((URI)new URI(uri), (Configuration)config) : FileSystem.get((Configuration)config);
                if (doAs != null) {
                    hdfs = FileSystem.get((URI)hdfs.getUri(), (Configuration)config, (String)doAs);
                }
            }
            return hdfs;
        }
        catch (Exception e) {
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
    }
}

