/*
 * Decompiled with CFR 0.152.
 */
package com.github.gbraccialli.hdfs;

import com.github.gbraccialli.hdfs.HDFSConfigUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import configuration.IConfiguration;
import inputs.HDFSInput;
import inputs.HadoopConcatInput;
import inputs.HdfsAclInput;
import inputs.HdfsDeleteInput;
import inputs.PathInfo;
import inputs.rackpath;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import util.BoundedExponentialRetryCallable;
import util.StackTraceUtil;
import util.ThreadSleeper;

public class DirectoryContentsUtils {
    public static long countEntries = 0L;
    private static Logger log = Logger.getLogger(DirectoryContentsUtils.class);
    private static volatile DirectoryContentsUtils tool = null;
    private static FileSystem hdfs;
    private static Boolean bAcl;
    private static Boolean bXattr;
    private IConfiguration config = null;

    @Inject
    public DirectoryContentsUtils(IConfiguration config) throws Exception {
        log.info((Object)"Getting driver meta data");
        this.config = config;
        hdfs = HDFSConfigUtils.loadConfigsAndGetFileSystem(config.gethadoopConfDir(), config.gethadoopURI(), config.getHadoopUser(), config.getKerberosTicket());
        if (hdfs != null) {
            String strXattr;
            String strAcl = hdfs.getConf().get("dfs.namenode.acls.enabled");
            if (strAcl != null && strAcl.equals("true")) {
                bAcl = true;
            }
            if ((strXattr = hdfs.getConf().get("dfs.namenode.xattrs.enabled")) != null && strXattr.equals("false")) {
                bXattr = false;
            }
            log.info((Object)("Acl: " + bAcl + ". Xattr " + bXattr));
        }
    }

    public static void main(String[] args) throws Exception {
        String confDir = "/etc/hadoop/conf";
        String path = "/";
        int maxLevelThreshold = -1;
        long minSizeThreshold = -1L;
        boolean showFiles = false;
        boolean verbose = false;
        String doAs = null;
        List<String> excludeList = null;
        for (String arg : args) {
            if (arg.startsWith("--confDir=")) {
                confDir = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--path=")) {
                path = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--maxLevelThreshold=")) {
                maxLevelThreshold = Integer.parseInt(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--minSizeThreshold=")) {
                minSizeThreshold = Long.parseLong(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--showFiles=")) {
                showFiles = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--verbose=")) {
                verbose = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--doAs=")) {
                doAs = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--exclude=")) {
                excludeList = Arrays.asList(arg.split("=")[1].split(","));
                continue;
            }
            log.info((Object)("Argumment not in list of valid arguments, it will be ignored:" + arg));
        }
        Date dateStart = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        FileSystem hdfs = HDFSConfigUtils.loadConfigsAndGetFileSystem(confDir, doAs);
        Path hdfsPath = new Path(path);
        if (verbose) {
            log.info((Object)("confDir=" + confDir));
            log.info((Object)("path=" + path));
            log.info((Object)("maxLevelThreshold=" + maxLevelThreshold));
            log.info((Object)("minSizeThreshold=" + minSizeThreshold));
            log.info((Object)("showFiles=" + showFiles));
            log.info((Object)("verbose=" + verbose));
            log.info((Object)("uri=" + hdfs.getUri().toString()));
            log.info((Object)("start at:" + dateFormat.format(dateStart)));
        }
        countEntries = 0L;
        DirectoryContentsUtils.directoryInfoToJson(DirectoryContentsUtils.listContents(hdfs, hdfsPath, 0, maxLevelThreshold, minSizeThreshold, showFiles, verbose, excludeList), System.out);
        if (verbose) {
            Date dateEnd = new Date();
            log.info((Object)"Date ");
            log.info((Object)("end at:" + dateFormat.format(dateEnd)));
            log.info((Object)("total entries : " + countEntries));
            log.info((Object)("elapsed time: " + (double)(dateEnd.getTime() - dateStart.getTime()) / 1000.0 + " seconds"));
        }
    }

    public static void directoryInfoToJson(PathInfo directoryInfo, Appendable writer) {
        Gson gson = new GsonBuilder().create();
        gson.toJson((Object)directoryInfo, writer);
    }

    public static String directoryInfoToJson(PathInfo directoryInfo) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)directoryInfo);
    }

    public static PathInfo listContents(FileSystem hdfs, Path path) throws Exception {
        String str = null;
        return DirectoryContentsUtils.listContents(hdfs, path, 0, -1, -1L, false, false, str);
    }

    public static PathInfo listContents(FileSystem hdfs, Path path, boolean verbose) throws Exception {
        String str = null;
        return DirectoryContentsUtils.listContents(hdfs, path, 0, -1, -1L, false, verbose, str);
    }

    public static boolean isInExclusionList(PathInfo pathInfo, List<String> excludeList) {
        boolean found = false;
        for (String excludePath : excludeList) {
            if (!pathInfo.getFullName().startsWith(excludePath)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static PathInfo listContents(FileSystem hdfs, Path path, int currentLevel, int maxLevelThreshold, long minSizeThreshold, boolean showFiles, boolean verbose, String excludeList) throws Exception {
        List<String> excludeArray = null;
        if (excludeList != null && excludeList.length() > 0) {
            excludeArray = Arrays.asList(excludeList.split(","));
        }
        return DirectoryContentsUtils.listContents(hdfs, path, 0, maxLevelThreshold, minSizeThreshold, showFiles, verbose, excludeArray);
    }

    public static PathInfo listContents(FileSystem hdfs, Path path, int currentLevel, int maxLevelThreshold, long minSizeThreshold, boolean showFiles, boolean verbose, List<String> excludeList) throws Exception {
        log.info((Object)("In List content: " + path.toString()));
        ++countEntries;
        PathInfo pathInfo = new PathInfo();
        ArrayList<PathInfo> children = new ArrayList<PathInfo>();
        try {
            FileStatus fileStatus = hdfs.getFileStatus(path);
            FsPermission fsPermissions = fileStatus.getPermission();
            fsPermissions.getUserAction().name();
            pathInfo.setName(path.getName());
            pathInfo.setFullName(fileStatus.getPath().toUri().getPath());
            pathInfo.setDirectory(fileStatus.isDirectory());
            pathInfo.setLength(fileStatus.getLen());
            pathInfo.setPermissions(fsPermissions);
            pathInfo.setUser(fileStatus.getOwner());
            pathInfo.setGroup(fileStatus.getGroup());
            pathInfo.setMtime(fileStatus.getModificationTime());
            pathInfo.setAtime(fileStatus.getAccessTime());
            pathInfo.setBlockSize(fileStatus.getBlockSize());
            if (!fileStatus.isDirectory() && fileStatus.getLen() != 0L) {
                BlockLocation[] blk = hdfs.getFileBlockLocations(path, 0L, fileStatus.getLen());
                pathInfo.setBlockLocation(blk);
                HashMap<String, Long> sizeMap = new HashMap<String, Long>();
                for (BlockLocation block : blk) {
                    for (String blockLoc : block.getTopologyPaths()) {
                        if (sizeMap.containsKey(blockLoc)) {
                            sizeMap.put(blockLoc, (Long)sizeMap.get(blockLoc) + block.getLength());
                            continue;
                        }
                        sizeMap.put(blockLoc, block.getLength());
                    }
                }
                Long BiggestValue = new Long(0L);
                String statEntry = path.getParent() + "/" + path.getName() + " " + fileStatus.getLen();
                String ReturnLoc = "";
                for (Map.Entry entry : sizeMap.entrySet()) {
                    statEntry = statEntry.concat(" " + (String)entry.getKey() + ":" + entry.getValue());
                    log.debug((Object)("Rack: " + (String)entry.getKey() + " Size:" + entry.getValue()));
                    if (BiggestValue >= (Long)entry.getValue()) continue;
                    ReturnLoc = (String)entry.getKey();
                    BiggestValue = (Long)entry.getValue();
                }
                log.info((Object)ReturnLoc);
                ReturnLoc = "/" + ReturnLoc.split("/")[1];
                pathInfo.setRack(ReturnLoc);
            }
            if (pathInfo.isDirectory()) {
                ContentSummary summary = hdfs.getContentSummary(path);
                long totalLength = summary.getLength();
                long totalSpaceConsumed = summary.getSpaceConsumed();
                pathInfo.setSpaceConsumed(totalSpaceConsumed);
                pathInfo.setNumberOfFiles(summary.getFileCount());
                long dirCount = summary.getDirectoryCount();
                if (dirCount > 0L) {
                    --dirCount;
                }
                pathInfo.setNumberOfSubDirectories(dirCount);
                if (verbose) {
                    log.info((Object)("Processing dir: " + pathInfo.getFullName()));
                }
                if (excludeList != null && DirectoryContentsUtils.isInExclusionList(pathInfo, excludeList)) {
                    pathInfo.setMessage("Drill down stopped due to file/folder is listed in exclusion list");
                } else if (maxLevelThreshold > -1 && currentLevel >= maxLevelThreshold) {
                    pathInfo.setMessage("Drill down stopped due to maxLevelThreshold achieved (" + maxLevelThreshold + ")");
                    if (verbose) {
                        log.info((Object)("Drill down stopped due to maxLevelThreshold achieved (" + maxLevelThreshold + ")"));
                    }
                } else if (minSizeThreshold > -1L && totalLength < minSizeThreshold) {
                    pathInfo.setMessage("Drill down stopped due to minSizeThreshold achieved (" + minSizeThreshold + ")");
                    if (verbose) {
                        log.info((Object)("Drill down stopped due to minSizeThreshold achieved (" + minSizeThreshold + ")"));
                    }
                } else {
                    long subDirsLength = 0L;
                    long subDirsSpaceConsumed = 0L;
                    long files = 0L;
                    for (FileStatus fs : hdfs.listStatus(path)) {
                        PathInfo child;
                        if (fs.isDirectory()) {
                            child = DirectoryContentsUtils.listContents(hdfs, fs.getPath(), currentLevel + 1, maxLevelThreshold, minSizeThreshold, showFiles, verbose, excludeList);
                            children.add(child);
                            subDirsLength += child.getLength();
                            subDirsSpaceConsumed += child.getSpaceConsumed();
                            continue;
                        }
                        if (showFiles) {
                            child = DirectoryContentsUtils.listContents(hdfs, fs.getPath(), currentLevel + 1, maxLevelThreshold, minSizeThreshold, showFiles, verbose, excludeList);
                            children.add(child);
                            continue;
                        }
                        ++files;
                    }
                    if (!showFiles && files > 0L) {
                        if (dirCount == 0L) {
                            pathInfo.setMessage("this directory doesn't have sub-directories");
                        } else {
                            PathInfo multipleFilesInfo = new PathInfo("+(" + files + " files)", hdfs.getFileStatus(path).getPath().toUri().getPath(), false, totalLength - subDirsLength, totalSpaceConsumed - subDirsSpaceConsumed, files, "this entry represents multiple files to reduce visualization pressure", hdfs.getFileBlockLocations(path, 0L, 0L).toString());
                            log.info((Object)("Getting block location [" + hdfs.getFileBlockLocations(path, 0L, 0L).toString() + "]"));
                            children.add(multipleFilesInfo);
                        }
                    }
                }
                pathInfo.setChildren(children);
            }
        }
        catch (Exception e) {
            pathInfo.setMessage("Error [" + e.getMessage() + "]");
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
        pathInfo.MinimizeBlockMap();
        return pathInfo;
    }

    public String getRack(rackpath path2) throws IOException {
        Path path = new Path(path2.getPath());
        FileStatus fileStatus = hdfs.getFileStatus(path);
        String ReturnLoc = "";
        if (!fileStatus.isDirectory()) {
            BlockLocation[] blk = hdfs.getFileBlockLocations(path, 0L, fileStatus.getLen());
            HashMap<String, Long> sizeMap = new HashMap<String, Long>();
            for (BlockLocation block : blk) {
                for (String blockLoc : block.getTopologyPaths()) {
                    if (sizeMap.containsKey(blockLoc)) {
                        sizeMap.put(blockLoc, (Long)sizeMap.get(blockLoc) + block.getLength());
                        continue;
                    }
                    sizeMap.put(blockLoc, block.getLength());
                }
            }
            Long BiggestValue = new Long(0L);
            for (Map.Entry vals : sizeMap.entrySet()) {
                log.debug((Object)("Rack: " + (String)vals.getKey() + " Size:" + vals.getValue()));
                if (BiggestValue >= (Long)vals.getValue()) continue;
                ReturnLoc = (String)vals.getKey();
                BiggestValue = (Long)vals.getValue();
            }
            ReturnLoc = "/" + ReturnLoc.split("/")[1];
        }
        return ReturnLoc;
    }

    public static PathInfo GSONGet(HDFSInput input) throws Exception {
        Path hdfsPath = new Path(input.getPath());
        return DirectoryContentsUtils.listContents(hdfs, hdfsPath, 0, input.getMaxLevelThreshold(), input.getMinSizeThreshold(), true, true, input.getExcludeList());
    }

    public static Long getSize(String path) throws Exception {
        Path calculateSize = new Path(path);
        return hdfs.getContentSummary(calculateSize).getSpaceConsumed();
    }

    private static boolean testConnection() {
        return tool != null;
    }

    public static DirectoryContentsUtils initialize(IConfiguration config) throws Exception {
        tool = DirectoryContentsUtils.connect(config);
        return tool;
    }

    public static synchronized DirectoryContentsUtils connect(IConfiguration config) throws Exception {
        if (!DirectoryContentsUtils.testConnection()) {
            if (tool != null) {
                tool.close();
            }
        } else {
            return tool;
        }
        return DirectoryContentsUtils.createConnection(config);
    }

    private void close() throws IOException {
        hdfs.close();
    }

    private static DirectoryContentsUtils createConnection(final IConfiguration config) throws Exception {
        if (tool != null) {
            try {
                tool.close();
            }
            catch (IOException e) {
                log.warn((Object)"Exception performing house cleaning -- closing current connection to jmx remote agent.");
                log.warn((Object)StackTraceUtil.getStackTrace(e));
            }
        }
        try {
            tool = (DirectoryContentsUtils)new BoundedExponentialRetryCallable<DirectoryContentsUtils>(){

                @Override
                public DirectoryContentsUtils retriableCall() throws Exception {
                    log.info((Object)"Creating hdfs connection");
                    DirectoryContentsUtils nodetool = new DirectoryContentsUtils(config);
                    return nodetool;
                }
            }.call();
        }
        catch (Exception e) {
            log.error((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e.getMessage());
        }
        return tool;
    }

    public static DirectoryContentsUtils instance(IConfiguration config) throws Exception {
        if (!DirectoryContentsUtils.testConnection()) {
            tool = DirectoryContentsUtils.connect(config);
        }
        return tool;
    }

    public String getRack(String pathStr) throws IOException {
        Path path = new Path(pathStr);
        FileStatus fileStatus = hdfs.getFileStatus(path);
        String ReturnLoc = "";
        if (!fileStatus.isDirectory()) {
            BlockLocation[] blk = hdfs.getFileBlockLocations(path, 0L, fileStatus.getLen());
            HashMap<String, Long> sizeMap = new HashMap<String, Long>();
            for (BlockLocation block : blk) {
                for (String blockLoc : block.getTopologyPaths()) {
                    if (sizeMap.containsKey(blockLoc)) {
                        sizeMap.put(blockLoc, (Long)sizeMap.get(blockLoc) + block.getLength());
                        continue;
                    }
                    sizeMap.put(blockLoc, block.getLength());
                }
            }
            Long BiggestValue = new Long(0L);
            for (Map.Entry vals : sizeMap.entrySet()) {
                log.debug((Object)("Rack: " + (String)vals.getKey() + " Size:" + vals.getValue()));
                if (BiggestValue >= (Long)vals.getValue()) continue;
                ReturnLoc = (String)vals.getKey();
                BiggestValue = (Long)vals.getValue();
            }
            ReturnLoc = "/" + ReturnLoc.split("/")[1];
        }
        return ReturnLoc;
    }

    public boolean CreatePath(String pathStr) throws IOException {
        FsPermission fsperm = new FsPermission("777");
        Path path = new Path(pathStr);
        return hdfs.mkdirs(path, fsperm);
    }

    public void ChangePermission(String pathStr, String User, String group) throws IOException {
        FsPermission fsperm = new FsPermission("760");
        Path path = new Path(pathStr);
        RemoteIterator fileStatusListIterator = hdfs.listLocatedStatus(path);
        while (fileStatusListIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            log.info((Object)("File" + fileStatus.getPath().toString()));
            if (fileStatus.isDirectory()) {
                this.ChangePermission(fileStatus.getPath().toString(), User, group);
            }
            hdfs.setOwner(fileStatus.getPath(), User, group);
            if (fileStatus.isDirectory()) {
                this.ChangePermission(fileStatus.getPath().toString(), User, group);
            }
            hdfs.setOwner(fileStatus.getPath(), User, group);
        }
    }

    public void ConcatFiles(HadoopConcatInput input) throws Exception {
        try {
            Path TargetFile = new Path(input.getPartFilePath());
            log.info((Object)("Target file " + TargetFile.getName()));
            Path parentdir = TargetFile.getParent();
            TreeMap<Integer, Path> pathMap = new TreeMap<Integer, Path>();
            short extentFileReplication = 3;
            for (FileStatus fs : hdfs.listStatus(parentdir)) {
                if (!fs.isFile() || !fs.getPath().getName().contains(TargetFile.getName() + ".cvpart.")) continue;
                log.info((Object)fs.getPath().getName());
                String[] SplitPath = fs.getPath().getName().split("\\.");
                if (Integer.valueOf(SplitPath[SplitPath.length - 1]) == 0) {
                    hdfs.rename(fs.getPath(), TargetFile);
                    extentFileReplication = fs.getReplication();
                    continue;
                }
                pathMap.put(Integer.valueOf(SplitPath[SplitPath.length - 1]), fs.getPath());
            }
            if (pathMap.size() > 0) {
                Path[] sourcePaths = new Path[pathMap.size()];
                sourcePaths = pathMap.values().toArray(new Path[pathMap.size()]);
                int retry = 10;
                while (retry-- != 0) {
                    try {
                        hdfs.concat(TargetFile, sourcePaths);
                        break;
                    }
                    catch (Exception ie) {
                        log.error((Object)StackTraceUtil.getStackTrace(ie));
                        if (retry == 0) {
                            throw ie;
                        }
                        ThreadSleeper sleeper = new ThreadSleeper();
                        sleeper.sleep(this.config.getWaitTime() * 1000);
                    }
                }
            }
            Path destPath = new Path(input.getFinalPath());
            FileStatus fileStatus = hdfs.getFileStatus(destPath);
            AclStatus aclStatus = bAcl != false ? hdfs.getAclStatus(destPath) : null;
            Map xattr = bXattr != false ? hdfs.getXAttrs(destPath) : null;
            hdfs.delete(destPath, false);
            if (input.getEncryptZoneDestination().booleanValue()) {
                if (hdfs.getConf().get("hadoop.security.crypto.codec.classes.aes.ctr.nopadding") == null) {
                    hdfs.getConf().set("hadoop.security.crypto.codec.classes.aes.ctr.nopadding", new String("org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec,org.apache.hadoop.crypto.JceAesCtrCryptoCodec"));
                }
                FileUtil.copy((FileSystem)hdfs, (Path)TargetFile, (FileSystem)hdfs, (Path)destPath, (boolean)false, (Configuration)hdfs.getConf());
                hdfs.delete(TargetFile, false);
            } else {
                hdfs.rename(TargetFile, destPath);
                if (extentFileReplication != fileStatus.getReplication()) {
                    log.debug((Object)("Changed replication factor from " + extentFileReplication + " to " + fileStatus.getReplication()));
                    hdfs.setReplication(destPath, fileStatus.getReplication());
                }
            }
            PathInfo oInfo = new PathInfo();
            oInfo.setFullName(destPath.toString());
            oInfo.setFsPermissions(fileStatus.getPermission());
            oInfo.setUser(fileStatus.getOwner());
            oInfo.setGroup(fileStatus.getGroup());
            oInfo.setAtime(fileStatus.getAccessTime());
            oInfo.setMtime(fileStatus.getModificationTime());
            oInfo.setAcl(aclStatus);
            oInfo.setXattr(xattr);
            this.setAttrs(oInfo);
        }
        catch (Exception ie) {
            log.error((Object)StackTraceUtil.getStackTrace(ie));
            throw ie;
        }
    }

    public FileSystem getFsObj() {
        return hdfs;
    }

    public String getAcl(HdfsAclInput input) throws IOException {
        try {
            Map mapAttrs;
            HdfsAclInput output = new HdfsAclInput();
            Path hdfsPath = new Path(input.getPath());
            Boolean isEmpty = true;
            if (bAcl.booleanValue()) {
                AclStatus aclStatus = hdfs.getAclStatus(hdfsPath);
                List lstAclEntry = aclStatus.getEntries();
                String strAcls = null;
                if (lstAclEntry != null && !lstAclEntry.isEmpty()) {
                    strAcls = AclEntry.aclSpecToString((List)lstAclEntry);
                }
                if (strAcls != null && !strAcls.isEmpty()) {
                    output.setAcl(strAcls);
                    isEmpty = false;
                }
            }
            if (bXattr.booleanValue() && (mapAttrs = hdfs.getXAttrs(hdfsPath)) != null && !mapAttrs.isEmpty()) {
                output.setXattr(mapAttrs);
                isEmpty = false;
            }
            if (!isEmpty.booleanValue()) {
                Gson gson = new GsonBuilder().create();
                return gson.toJson((Object)output);
            }
            return "";
        }
        catch (Exception ie) {
            log.error((Object)StackTraceUtil.getStackTrace(ie));
            throw ie;
        }
    }

    public void setAcl(HdfsAclInput input) throws IOException {
        try {
            List lstAclEntry;
            Path hdfsPath = new Path(input.getPath());
            if (bAcl.booleanValue() && input.getAcl() != null && !input.getAcl().isEmpty() && (lstAclEntry = AclEntry.parseAclSpec((String)input.getAcl(), (boolean)true)) != null && !lstAclEntry.isEmpty()) {
                hdfs.modifyAclEntries(hdfsPath, lstAclEntry);
            }
            if (bXattr.booleanValue() && input.getXattr() != null && !input.getXattr().isEmpty()) {
                for (Map.Entry<String, byte[]> oAttr : input.getXattr().entrySet()) {
                    hdfs.setXAttr(hdfsPath, oAttr.getKey(), oAttr.getValue());
                }
            }
        }
        catch (Exception ie) {
            log.error((Object)StackTraceUtil.getStackTrace(ie));
            throw ie;
        }
    }

    public void setAttrs(PathInfo input) throws IOException {
        Path hdfsPath = new Path(input.getFullName());
        if (!hdfs.exists(hdfsPath)) {
            hdfs.createNewFile(hdfsPath);
        }
        hdfs.setPermission(hdfsPath, input.getFsPermissions());
        hdfs.setOwner(hdfsPath, input.getUser(), input.getGroup());
        try {
            hdfs.setTimes(hdfsPath, input.getMtime(), input.getAtime());
        }
        catch (Exception ie) {
            log.error((Object)"Unable to set the required time values");
            log.error((Object)StackTraceUtil.getStackTrace(ie));
        }
        if (input.getAcl() != null) {
            hdfs.modifyAclEntries(hdfsPath, input.getAcl().getEntries());
        }
        if (input.getXattr() != null && !input.getXattr().isEmpty()) {
            for (Map.Entry<String, byte[]> attr : input.getXattr().entrySet()) {
                hdfs.setXAttr(hdfsPath, attr.getKey(), attr.getValue());
            }
        }
    }

    public Map<String, byte[]> getExtendedAttributes(String path) throws IOException {
        Path hdfsPath = new Path(path);
        return hdfs.getXAttrs(hdfsPath);
    }

    public void setXAttributes(Map<String, byte[]> xattr, String path) throws IOException {
        Path hdfsPath = new Path(path);
        for (Map.Entry<String, byte[]> attr : xattr.entrySet()) {
            hdfs.setXAttr(hdfsPath, attr.getKey(), attr.getValue());
        }
    }

    public void deleteFiles(HdfsDeleteInput input) throws IOException {
        Path deleteThis = new Path(input.getPath());
        log.info((Object)("Deleting " + deleteThis.toString()));
        if (!hdfs.delete(deleteThis, input.getRecurse().booleanValue())) {
            throw new IOException("Unable to delete the file");
        }
    }

    static {
        bAcl = false;
        bXattr = true;
    }
}

