/*
 * Decompiled with CFR 0.152.
 */
package cvdctm;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.DfClient;
import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfClient;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.client.IDfVirtualDocument;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLoginInfo;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.operations.IDfCheckinNode;
import com.documentum.operations.IDfCheckinOperation;
import cvdctm.CmdParser;
import cvdctm.DctmServer;
import cvdctm.DistributedStore;
import cvdctm.DocumentAttributes;
import cvdctm.ListAllVersions;
import cvdctm.Store;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

class CvDctm {
    String m_docbaseName = null;
    String m_docbaseId = null;
    String m_version = null;
    String m_dbname = null;
    String m_dbType = null;
    String m_userName;
    String m_userPasswd;
    String m_userDomain;
    int m_fti_enabled = -1;
    int m_dsa = -1;
    private IDfSession m_session = null;
    private Vector<Store> m_vstore = new Vector();
    private Vector<DistributedStore> m_vdstore = new Vector();
    private Vector<String> m_vfti;
    private CmdParser m_parser;
    private BufferedWriter m_writer;
    Logger logger;
    static final String FILE_SEP = System.getProperty("file.separator");
    static int CLDCTM_AGENT_CONNECT_ERR = 10;
    static int CLDCTM_AGENT_DISCOVER_ERR = 20;
    static int CLDCTM_AGENT_REGISTER_TABLES_ERR = 30;
    Vector<DctmServer> m_vServers = new Vector();
    Boolean m_redirectRestore = false;
    String m_restoreDestPath = "";

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static String getDocViewPrefixPath() {
        String string = "/+CVDOCVIEW";
        if (CvDctm.isWindows()) {
            string = "\\+CVDOCVIEW";
        }
        return string;
    }

    void addServer(String string, String string2) {
        DctmServer dctmServer = new DctmServer(string, string2);
        this.m_vServers.add(dctmServer);
    }

    void addFarStore(String string, String string2) {
        int n = this.m_vServers.size();
        int n2 = 0;
        for (n2 = 0; n2 < n && !this.m_vServers.elementAt(n2).getServer().equals(string); ++n2) {
        }
        if (n2 == n) {
            DctmServer dctmServer = new DctmServer(string, "");
            this.m_vServers.add(dctmServer);
        }
        this.m_vServers.elementAt(n2).addFarStore(string2);
    }

    int addFarStores() throws DfException {
        String string = "SELECT object_name, far_stores from dm_server_config";
        IDfCollection iDfCollection = null;
        IDfTypedObject iDfTypedObject = this.m_session.getServerMap(this.m_session.getDocbaseName());
        int n = iDfTypedObject.getValueCount("r_server_name");
        for (int i = 0; i < n; ++i) {
            String string2 = iDfTypedObject.getRepeatingString("r_server_name", i);
            String string3 = iDfTypedObject.getRepeatingString("r_host_name", i);
            this.logger.info("host name: " + string3 + " Server name : " + string2);
            this.addServer(string2, string3);
        }
        iDfCollection = this.execQuery(string, 4);
        if (iDfCollection != null) {
            while (iDfCollection.next()) {
                String string4 = iDfCollection.getString("far_stores");
                if (string4 == null || string4.equals("")) continue;
                this.addFarStore(iDfCollection.getString("object_name"), string4);
            }
            iDfCollection.close();
        }
        return 0;
    }

    String getProbableHost(String string) {
        String string2 = "";
        for (int i = 0; i < this.m_vServers.size(); ++i) {
            if (this.m_vServers.elementAt(i).isFarStore(string).booleanValue()) continue;
            string2 = this.m_vServers.elementAt(i).getHost();
        }
        this.logger.info("Returning hsot name " + string2 + " for SA " + string);
        return string2;
    }

    CvDctm() {
        this.m_vfti = new Vector();
        this.m_parser = new CmdParser();
        try {
            this.logger = Logger.getLogger("CvDctm");
            FileHandler fileHandler = new FileHandler(this.m_parser.getLogFile(), 524288, 2, true);
            this.logger.addHandler(fileHandler);
            this.logger.setLevel(Level.ALL);
            fileHandler.setFormatter(new SimpleFormatter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getAllSAInfo() throws DfException {
        int n = 0;
        String string = "select r_object_id from dm_filestore;";
        IDfCollection iDfCollection = null;
        String string2 = "";
        String[] stringArray = null;
        iDfCollection = this.execQuery(string, 0);
        if (iDfCollection != null) {
            while (iDfCollection.next()) {
                Store store;
                string2 = "";
                String string3 = iDfCollection.getString("r_object_id");
                IDfPersistentObject iDfPersistentObject = this.m_session.getObjectByQualification("dm_filestore where r_object_id = '" + string3 + "'");
                String string4 = iDfPersistentObject.getString("root");
                IDfPersistentObject iDfPersistentObject2 = this.m_session.getObjectByQualification("dm_location where object_name ='" + string4 + "'");
                if (iDfPersistentObject2 != null) {
                    String string5 = iDfPersistentObject2.getString("mount_point_name");
                    if (!string5.equals("")) {
                        store = this.m_session.getObjectByQualification("dm_mount_point where object_name ='" + string5 + "'");
                        if (store != null) {
                            string2 = store.getString("file_system_path") + FILE_SEP;
                        } else {
                            this.logger.severe("Invalid mountpoint_name " + string5);
                        }
                    }
                    string2 = string2 + iDfPersistentObject2.getString("file_system_path") + FILE_SEP + this.m_docbaseId;
                }
                store = new Store(string3, iDfPersistentObject.getString("name"), string2, iDfPersistentObject.getBoolean("use_extensions"), iDfPersistentObject.getBoolean("crypto_mode"));
                this.m_vstore.add(store);
                this.logger.info("Adding Store " + iDfPersistentObject.getString("name") + "fs_path= " + string2);
            }
            iDfCollection.close();
        } else {
            this.logger.severe("Failed to get SA List from Repository");
            n = -1;
        }
        stringArray = this.m_parser.getSAList();
        if (stringArray != null) {
            block1: for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < this.m_vstore.size(); ++j) {
                    if (!this.m_vstore.elementAt(j).GetStoreName().equalsIgnoreCase(stringArray[i])) continue;
                    this.m_vstore.elementAt(j).SetSelected(true);
                    this.logger.info("File Store " + this.m_vstore.elementAt(j).GetStoreName() + " is selected for Backup");
                    System.out.println("File Store " + this.m_vstore.elementAt(j).GetStoreName() + " is selected for Backup");
                    continue block1;
                }
            }
        }
        n = this.addFarStores();
        for (int i = 0; i < this.m_vstore.size(); ++i) {
            this.m_vstore.elementAt(i).SetHostName(this.getProbableHost(this.m_vstore.elementAt(i).GetStoreName()));
            this.logger.info("File Store " + this.m_vstore.elementAt(i).GetStoreName() + " is located on host " + this.m_vstore.elementAt(i).GetHostName());
        }
        return n;
    }

    protected int getAllFTIInfo() throws DfException {
        String string = "select index_name from dm_fulltext_index";
        String string2 = "";
        int n = 0;
        this.logger.info("getAllFTIInfo Enter");
        IDfCollection iDfCollection = this.execQuery(string, 4);
        if (iDfCollection != null) {
            while (iDfCollection.next()) {
                StringBuffer stringBuffer = new StringBuffer(1024);
                String string3 = iDfCollection.getString("index_name");
                stringBuffer.append(string3);
                String string4 = "select ft_engine_id from dm_fulltext_index where index_name ='" + string3 + "'";
                IDfCollection iDfCollection2 = this.execQuery(string4, 4);
                if (iDfCollection2 == null) continue;
                if (!iDfCollection2.next()) break;
                String string5 = "select param_name, param_value from dm_ftengine_config_r where r_object_id='" + iDfCollection2.getId("ft_engine_id").toString() + "' and param_name='fds_config_host'";
                IDfCollection iDfCollection3 = this.execQuery(string5, 3);
                if (iDfCollection3 != null) {
                    if (iDfCollection3.next()) {
                        string2 = iDfCollection3.getString("param_value");
                        stringBuffer.append("|");
                        stringBuffer.append(string2);
                    }
                    iDfCollection3.close();
                }
                iDfCollection2.close();
                this.logger.info("found FTI Index " + string3 + " on host " + string2);
                System.out.println("FTI=" + stringBuffer.toString());
                this.m_vfti.add(stringBuffer.toString());
            }
            iDfCollection.close();
        } else {
            this.logger.info("No FTI Indexes found");
            this.m_fti_enabled = 0;
        }
        return n;
    }

    public void setErrorMsg(String string) {
        System.out.println(string);
        this.logger.severe(string);
        try {
            File file = new File(this.m_parser.getErrMsgFile());
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to log error message to log file " + this.m_parser.getErrMsgFile() + " error = " + exception.toString());
        }
    }

    public int runDiscover() {
        int n = 0;
        try {
            this.logger.info("In runDiscover");
            n = this.getAllSAInfo();
            if (n == 0) {
                for (int i = 0; i < this.m_vstore.size(); ++i) {
                    this.logger.info(" Store name " + this.m_vstore.elementAt(i).GetStoreName() + " host name " + this.m_vstore.elementAt(i).GetHostName() + " fs_path " + this.m_vstore.elementAt(i).GetFilePath());
                    System.out.println("SA=" + this.m_vstore.elementAt(i).GetStoreName() + "|" + this.m_vstore.elementAt(i).GetHostName() + "|" + this.m_vstore.elementAt(i).GetFilePath());
                }
            }
            this.getAllFTIInfo();
            if (this.m_parser.getDiscover().booleanValue() && !this.m_parser.getPreBackup().booleanValue()) {
                this.writeStoreDetails();
            }
        }
        catch (Exception exception) {
            String string = "runDiscover failed " + exception.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
        }
        return n;
    }

    public int getDistributedSAList() throws DfException {
        String string = "select name, r_object_id, r_component_count from dm_distributedstore;";
        IDfCollection iDfCollection = null;
        int n = 0;
        int n2 = 0;
        iDfCollection = this.execQuery(string, 0);
        if (iDfCollection != null) {
            while (iDfCollection.next()) {
                HashMap<String, Store> hashMap = new HashMap<String, Store>();
                String string2 = iDfCollection.getString("r_object_id");
                String string3 = iDfCollection.getString("name");
                n = iDfCollection.getInt("r_component_count");
                if (n <= 0) break;
                String[] stringArray = new String[n];
                string = "select r_component from dm_distributedstore_rp where  r_object_id='" + string2 + "';";
                IDfCollection iDfCollection2 = this.execQuery(string, 0);
                if (iDfCollection2 != null) {
                    n2 = 0;
                    while (iDfCollection2.next()) {
                        stringArray[n2] = iDfCollection2.getString("r_component");
                        hashMap.put(stringArray[n2], this.getStoreById(stringArray[n2]));
                        ++n2;
                    }
                    iDfCollection2.close();
                }
                DistributedStore distributedStore = new DistributedStore(string2, string3, stringArray, hashMap);
                this.m_vdstore.add(distributedStore);
                this.logger.info("AddingDistributed  Store " + string3 + "component_count =  " + n);
            }
            iDfCollection.close();
        }
        return 0;
    }

    public Boolean isSelected(String string) {
        Boolean bl = false;
        for (int i = 0; i < this.m_vstore.size(); ++i) {
            if (!this.m_vstore.elementAt(i).GetStoreId().equals(string)) continue;
            bl = this.m_vstore.elementAt(i).GetSelected();
            break;
        }
        return bl;
    }

    public IDfCollection getContentFiles(int n) throws DfException {
        String string = this.m_vstore.elementAt(n).GetStoreId();
        IDfCollection iDfCollection = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n2 = this.m_vstore.elementAt(n).GetStartTicket();
        int n3 = this.m_vstore.elementAt(n).GetEndTicket();
        stringBuffer.append("select cs.r_object_id AS content_id, cs.storage_id, cs.data_ticket,  cs.full_format, cs.content_size, cs.format, cs.rendition, cs.set_file, cs.set_client, cr.parent_id, s.r_object_id AS object_id, s.object_name, s.owner_name, s.r_creation_date, sr.r_version_label, sr.i_folder_id, fr.r_folder_path, fm.r_object_id AS format_id, fm.dos_extension  FROM dmr_content_s cs, dmr_content_r cr, dm_sysobject_s s, dm_sysobject_r sr, dm_folder_r fr, dm_format_s fm ");
        stringBuffer.append(" WHERE cs.storage_id = '").append(string).append("' ");
        stringBuffer.append(" AND cr.r_object_id = cs.r_object_id  AND s.r_object_id = cr.parent_id AND sr.r_object_id = s.r_object_id AND sr.i_position = -1 AND fr.r_object_id = sr.i_folder_id AND fr.i_position = -1 and ");
        if (!this.m_parser.getIncludeReports().booleanValue()) {
            stringBuffer.append(" fr.r_folder_path != '/System/Sysadmin/Reports' and fr.r_folder_path NOT LIKE '/Temp/%' and  ");
        }
        stringBuffer.append(" fm.r_object_id = cs.format ");
        if (n3 > Integer.MIN_VALUE) {
            stringBuffer.append(" and  data_ticket <= ").append(n3);
        }
        if (n2 > Integer.MIN_VALUE) {
            stringBuffer.append(" and  data_ticket >= ").append(n2 + 1);
        }
        stringBuffer.append(" order by  fr.r_folder_path,  s.object_name,  s.r_creation_date, sr.r_version_label;");
        System.out.println("query = " + stringBuffer.toString());
        iDfCollection = this.execQuery(stringBuffer.toString(), 0);
        return iDfCollection;
    }

    public IDfCollection getDistributedContentFiles(int n) throws DfException {
        DistributedStore distributedStore = this.m_vdstore.elementAt(n);
        IDfCollection iDfCollection = null;
        String[] stringArray = distributedStore.GetComponents();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isSelected(stringArray[i]).booleanValue()) continue;
            stringBuffer.append("'").append(stringArray[i]).append("',");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(") ");
        if (stringBuffer.length() > 3) {
            StringBuffer stringBuffer2 = new StringBuffer(1024);
            stringBuffer2.append("select cs.r_object_id AS content_id, cs.storage_id, rr.data_ticket,  cs.full_format, cs.content_size, cs.format, cs.rendition, cs.set_file, cs.set_client, cr.parent_id, s.r_object_id AS object_id, s.object_name, s.owner_name, s.r_creation_date, sr.r_version_label, sr.i_folder_id, fr.r_folder_path, rr.component_id, fm.r_object_id AS format_id, fm.dos_extension  FROM dmr_content_s cs, dmr_content_r cr, dm_sysobject_s s, dm_sysobject_r sr, dm_folder_r fr, dm_format_s fm , dmi_replica_record_r rr, dmi_replica_record_s rs  WHERE    cs.data_ticket = rs.r_storage_ticket    AND rr.r_object_id = rs.r_object_id   AND rr.component_id in ").append(stringBuffer.toString());
            stringBuffer2.append(" and rr.data_ticket != 0 and cs.storage_id = rs.owner_id  and cr.r_object_id = cs.r_object_id  and s.r_object_id = cr.parent_id and sr.r_object_id = s.r_object_id and sr.i_position = -1 and fr.r_object_id = sr.i_folder_id and fr.i_position = -1 and ");
            if (!this.m_parser.getIncludeReports().booleanValue()) {
                stringBuffer2.append(" fr.r_folder_path != '/System/Sysadmin/Reports' and fr.r_folder_path NOT LIKE '/Temp/%' and ");
            }
            stringBuffer2.append(" fm.r_object_id = cs.format ");
            stringBuffer2.append(" order by fr.r_folder_path,  s.object_name, s.r_creation_date, sr.r_version_label;");
            System.out.println("query = %s" + stringBuffer2.toString());
            iDfCollection = this.execQuery(stringBuffer2.toString(), 0);
        }
        return iDfCollection;
    }

    public Store getStoreById(String string) {
        Store store = null;
        for (int i = 0; i < this.m_vstore.size(); ++i) {
            if (!this.m_vstore.elementAt(i).GetStoreId().equals(string)) continue;
            store = this.m_vstore.elementAt(i);
            break;
        }
        return store;
    }

    public Store getStore(String string) {
        Store store = null;
        for (int i = 0; i < this.m_vstore.size(); ++i) {
            if (!this.m_vstore.elementAt(i).GetStoreName().equals(string)) continue;
            store = this.m_vstore.elementAt(i);
            break;
        }
        return store;
    }

    public void writeStoreDetails() throws IOException {
        StringBuffer stringBuffer;
        int n;
        Store store = null;
        File file = new File(this.m_parser.getResponseFile());
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        stringBuffer2.append("doc|");
        stringBuffer2.append(this.m_docbaseName);
        stringBuffer2.append("|");
        stringBuffer2.append(this.m_version);
        stringBuffer2.append("|");
        stringBuffer2.append(this.m_docbaseId);
        bufferedWriter.write(stringBuffer2.toString());
        bufferedWriter.newLine();
        this.logger.severe("writeStoreDetails(): response file = " + file);
        for (n = 0; n < this.m_vstore.size(); ++n) {
            store = this.m_vstore.elementAt(n);
            if (!this.m_parser.getDiscover().booleanValue() && (!this.m_parser.getScanPhase().booleanValue() || !store.GetSelected())) continue;
            stringBuffer = new StringBuffer(1024);
            stringBuffer.append("FSA|");
            stringBuffer.append(store.GetStoreName());
            stringBuffer.append("|");
            if (store.GetHostName().length() > 0) {
                stringBuffer.append(store.GetHostName());
            } else {
                stringBuffer.append("unknown");
            }
            stringBuffer.append("|");
            stringBuffer.append(store.GetFilePath());
            stringBuffer.append("|");
            stringBuffer.append(store.GetEndTicket());
            stringBuffer.append("|");
            stringBuffer.append(store.GetEncrypted());
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
        }
        if (this.m_parser.getDiscover().booleanValue()) {
            for (n = 0; n < this.m_vfti.size(); ++n) {
                stringBuffer = new StringBuffer(1024);
                stringBuffer.append("FTI|");
                stringBuffer.append(this.m_vfti.elementAt(n));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public String getHexStringTicket(int n) {
        String string = Integer.toHexString(n).toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(8);
        for (int i = 0; i < 8 - string.length(); ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int writeFileReport(IDfCollection iDfCollection, DistributedStore distributedStore) throws DfException, IOException {
        Map<String, Store> map = distributedStore.GetComponentMap();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while (iDfCollection.next()) {
            int n = iDfCollection.getInt("data_ticket");
            String string7 = this.getHexStringTicket(n);
            StringBuffer stringBuffer = new StringBuffer();
            String string8 = iDfCollection.getString("component_id");
            int n2 = map.get(string8).GetStartTicket();
            int n3 = map.get(string8).GetEndTicket();
            if (n > n3 || n2 != Integer.MIN_VALUE && n <= n2) continue;
            stringBuffer.append(FILE_SEP);
            stringBuffer.append("Storage Area");
            stringBuffer.append(FILE_SEP).append(map.get(string8).GetStoreName());
            if (CvDctm.isWindows()) {
                stringBuffer.append(FILE_SEP);
            }
            stringBuffer.append(map.get(string8).GetFilePath()).append(FILE_SEP);
            stringBuffer.append(string7.substring(0, 2)).append(FILE_SEP).append(string7.substring(2, 4)).append(FILE_SEP).append(string7.substring(4, 6)).append(FILE_SEP).append(string7.substring(6, 8));
            String string9 = iDfCollection.getString("format_id");
            String string10 = iDfCollection.getString("dos_extension");
            if (map.get(string8).GetUseExtensions().booleanValue() && !string9.equals("") && string9 != "0000000000000000" && !string10.equals("")) {
                stringBuffer.append(".");
                stringBuffer.append(string10);
            }
            StringBuffer stringBuffer2 = new StringBuffer(1024);
            string2 = iDfCollection.getString("object_id");
            string4 = iDfCollection.getString("object_name");
            string6 = iDfCollection.getString("r_folder_path");
            if (string4.equals("")) continue;
            if (!string3.equals(string4) || !string5.equals(string6)) {
                stringBuffer2.append(CvDctm.getDocViewPrefixPath());
                stringBuffer2.append(iDfCollection.getString("r_folder_path")).append(FILE_SEP);
                stringBuffer2.append(string4);
                stringBuffer2.append("\n");
                string3 = string4;
                string5 = string6;
            }
            if (!string.equals(string2)) {
                stringBuffer2.append("\t").append(iDfCollection.getString("r_version_label")).append("|");
                stringBuffer2.append(iDfCollection.getString("owner_name")).append("|");
                stringBuffer2.append(iDfCollection.getString("object_id")).append("|");
                stringBuffer2.append(iDfCollection.getString("r_creation_date")).append("|");
                stringBuffer2.append(iDfCollection.getString("full_format")).append("|");
                stringBuffer2.append(iDfCollection.getInt("content_size")).append("\n");
            }
            stringBuffer2.append("\t\t").append(stringBuffer).append("|").append(iDfCollection.getInt("rendition")).append("\n");
            this.m_writer.write(stringBuffer2.toString());
            string = string2;
        }
        this.m_writer.flush();
        iDfCollection.close();
        return 0;
    }

    public int writeFileReport(IDfCollection iDfCollection, Store store) throws DfException, IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while (iDfCollection.next()) {
            int n = iDfCollection.getInt("data_ticket");
            String string7 = this.getHexStringTicket(n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FILE_SEP).append("Storage Area");
            stringBuffer.append(FILE_SEP).append(store.GetStoreName());
            if (CvDctm.isWindows()) {
                stringBuffer.append(FILE_SEP);
            }
            stringBuffer.append(store.GetFilePath()).append(FILE_SEP);
            stringBuffer.append(string7.substring(0, 2)).append(FILE_SEP).append(string7.substring(2, 4)).append(FILE_SEP).append(string7.substring(4, 6)).append(FILE_SEP).append(string7.substring(6, 8));
            String string8 = iDfCollection.getString("format_id");
            String string9 = iDfCollection.getString("dos_extension");
            if (store.GetUseExtensions().booleanValue() && !string8.equals("") && string8 != "0000000000000000" && !string9.equals("")) {
                stringBuffer.append(".");
                stringBuffer.append(string9);
            }
            StringBuffer stringBuffer2 = new StringBuffer(1024);
            string2 = iDfCollection.getString("object_id");
            string4 = iDfCollection.getString("object_name");
            string4 = string4.trim();
            string6 = iDfCollection.getString("r_folder_path");
            if (string4.equals("")) continue;
            if (!string3.equals(string4) || !string5.equals(string6)) {
                stringBuffer2.append(CvDctm.getDocViewPrefixPath());
                stringBuffer2.append(iDfCollection.getString("r_folder_path")).append(FILE_SEP);
                stringBuffer2.append(string4);
                stringBuffer2.append("\n");
                string3 = string4;
                string5 = string6;
            }
            if (!string.equals(string2)) {
                stringBuffer2.append("\t").append(iDfCollection.getString("r_version_label")).append("|");
                stringBuffer2.append(iDfCollection.getString("owner_name")).append("|");
                stringBuffer2.append(iDfCollection.getString("object_id")).append("|");
                stringBuffer2.append(iDfCollection.getString("r_creation_date")).append("|");
                stringBuffer2.append(iDfCollection.getString("full_format")).append("|");
                stringBuffer2.append(iDfCollection.getInt("content_size")).append("\n");
            }
            stringBuffer2.append("\t\t").append(stringBuffer).append("|").append(iDfCollection.getInt("rendition")).append("\n");
            string = string2;
            if (CvDctm.isWindows()) {
                this.m_writer.write(stringBuffer2.toString().replace('/', '\\'));
            } else {
                this.m_writer.write(stringBuffer2.toString());
            }
            string = string2;
        }
        this.m_writer.flush();
        iDfCollection.close();
        return 0;
    }

    public void getStartEndTickets() {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_parser.getSplitDctm()));
            String string = "";
            String string2 = "";
            String string3 = "";
            int n2 = 0;
            string = bufferedReader.readLine();
            if (string != null) {
                String[] stringArray = string.split(";");
                for (n = 0; n < stringArray.length; ++n) {
                    n2 = stringArray[n].indexOf(61);
                    string2 = stringArray[n].substring(0, n2);
                    string3 = stringArray[n].substring(n2 + 1);
                    this.getStore(string2).SetEndTicket(Integer.parseInt(string3));
                }
            }
            if ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(";");
                for (n = 0; n < stringArray.length; ++n) {
                    n2 = stringArray[n].indexOf(61);
                    string2 = stringArray[n].substring(0, n2);
                    string3 = stringArray[n].substring(n2 + 1);
                    this.getStore(string2).SetStartTicket(Integer.parseInt(string3));
                }
            }
        }
        catch (Exception exception) {
            String string = "getStartEndTickets failed " + exception.toString();
            this.logger.severe(string);
        }
    }

    public int runFileReport() {
        int n = 0;
        System.out.println("runFileReport enter");
        boolean bl = false;
        IDfCollection iDfCollection = null;
        try {
            int n2;
            String string = this.m_parser.getResponseFile() + ".done";
            File file = new File(this.m_parser.getResponseFile());
            this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.getStartEndTickets();
            for (n2 = 0; n2 < this.m_vstore.size(); ++n2) {
                System.out.println("store name " + this.m_vstore.elementAt(n2).GetStoreName());
                bl = this.m_vstore.elementAt(n2).GetSelected();
                if (!bl || (iDfCollection = this.getContentFiles(n2)) == null) continue;
                this.writeFileReport(iDfCollection, this.m_vstore.elementAt(n2));
            }
            if (this.isDistributed().booleanValue()) {
                this.getDistributedSAList();
            }
            for (n2 = 0; n2 < this.m_vdstore.size(); ++n2) {
                iDfCollection = this.getDistributedContentFiles(n2);
                if (iDfCollection == null) continue;
                this.writeFileReport(iDfCollection, this.m_vdstore.elementAt(n2));
            }
            File file2 = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            bufferedWriter.write("report complete " + string);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            String string = "runFileReport failed " + exception.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public int runPreBackup() {
        int n = 0;
        try {
            this.getEndTickets();
            this.writeStoreDetails();
            if (this.m_parser.getSASelected().booleanValue()) {
                this.setJobStatus("dm_DMClean", true);
                this.setJobStatus("dm_DMFilescan", true);
            }
        }
        catch (Exception exception) {
            String string = "Disabling jobs during PreBackup phase failed " + exception.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public int runPostBackup() {
        int n = 0;
        try {
            if (this.m_parser.getSASelected().booleanValue()) {
                this.setJobStatus("dm_DMClean", false);
                this.setJobStatus("dm_DMFilescan", false);
            }
        }
        catch (DfException dfException) {
            String string = "Resuming jobs during PostBackup phase failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public int setEndTicket(String string, int n) {
        for (int i = 0; i < this.m_vstore.size(); ++i) {
            if (!this.m_vstore.elementAt(i).GetStoreId().equals(string)) continue;
            if (n <= this.m_vstore.elementAt(i).GetEndTicket()) break;
            this.m_vstore.elementAt(i).SetEndTicket(n);
            break;
        }
        return 0;
    }

    public int getEndTickets() throws DfException {
        IDfCollection iDfCollection;
        String string;
        String string2 = "select distinct storage_id from dmr_content where storage_id !='0000000000000000'";
        String string3 = "select distinct component_id from dmi_replica_record_r where component_id !='0000000000000000'";
        int n = Integer.MIN_VALUE;
        IDfCollection iDfCollection2 = this.execQuery(string2, 4);
        if (iDfCollection2 != null) {
            while (iDfCollection2.next()) {
                string = iDfCollection2.getString("storage_id");
                string2 = "select max(data_ticket) as max_ticket from dmr_content where storage_id='" + string + "'";
                iDfCollection = this.execQuery(string2, 4);
                if (iDfCollection == null) continue;
                if (iDfCollection.next()) {
                    n = iDfCollection.getInt("max_ticket");
                    this.setEndTicket(string, n);
                    this.logger.info("Store id " + string + " end ticket " + n);
                    System.out.println("Store id " + string + " end ticket " + n);
                }
                iDfCollection.close();
            }
            iDfCollection2.close();
        }
        if ((iDfCollection2 = this.execQuery(string3, 4)) != null) {
            while (iDfCollection2.next()) {
                string = iDfCollection2.getString("component_id");
                string2 = "select max(data_ticket) as max_ticket from dmi_replica_record_r where component_id='" + string + "'";
                iDfCollection = this.execQuery(string2, 4);
                if (iDfCollection == null) continue;
                if (iDfCollection.next()) {
                    n = iDfCollection.getInt("max_ticket");
                    this.setEndTicket(string, n);
                    this.logger.info("Store id " + string + " end ticket " + n);
                    System.out.println("Store id " + string + " end ticket " + n);
                }
                iDfCollection.close();
            }
            iDfCollection2.close();
        }
        return n;
    }

    public int writeIncrementalCollectFiles() {
        return 0;
    }

    public int runScanPhase() {
        int n = 0;
        try {
            this.getEndTickets();
            if (this.m_parser.getBkpLevel() > 0) {
                // empty if block
            }
            this.writeStoreDetails();
        }
        catch (Exception exception) {
            String string = "getting Last ticket for SA failed " + exception.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public int runPreRestore() {
        int n = 0;
        try {
            if (this.m_parser.getSASelected().booleanValue()) {
                this.setJobStatus("dm_DMClean", true);
                this.setJobStatus("dm_DMFilescan", true);
            }
        }
        catch (DfException dfException) {
            String string = "Resuming jobs during PostRestore phase failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = -1;
        }
        return n;
    }

    public int runPostRestore() {
        int n = 0;
        try {
            if (this.m_parser.getSASelected().booleanValue()) {
                this.setJobStatus("dm_DMClean", false);
                this.setJobStatus("dm_DMFilescan", false);
            }
        }
        catch (DfException dfException) {
            String string = "Resuming jobs during PostRestore phase failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public int runAction(String[] stringArray) {
        int n = 0;
        this.m_parser.parseArgs(stringArray);
        this.m_docbaseName = this.m_parser.getDocBaseName();
        this.m_userName = this.m_parser.getUserName();
        this.m_userPasswd = this.m_parser.getPasswd();
        this.m_userDomain = this.m_parser.getUserDomain();
        if (!this.connectToDocbase().booleanValue()) {
            return CLDCTM_AGENT_CONNECT_ERR;
        }
        if (!this.getSessionProperties().booleanValue()) {
            return CLDCTM_AGENT_CONNECT_ERR;
        }
        if (this.m_parser.getRestore().booleanValue()) {
            return this.runRestore();
        }
        if (this.runDiscover() != 0) {
            return CLDCTM_AGENT_DISCOVER_ERR;
        }
        if (this.registerDbTables() != 0) {
            return CLDCTM_AGENT_REGISTER_TABLES_ERR;
        }
        if (this.m_parser.getPreBackup().booleanValue()) {
            return this.runPreBackup();
        }
        if (this.m_parser.getScanPhase().booleanValue()) {
            return this.runScanPhase();
        }
        if (this.m_parser.getPostBackup().booleanValue()) {
            return this.runPostBackup();
        }
        if (this.m_parser.getPreRestore().booleanValue()) {
            return this.runPreRestore();
        }
        if (this.m_parser.getPostRestore().booleanValue()) {
            return this.runPostRestore();
        }
        if (this.m_parser.getFileReport().booleanValue()) {
            return this.runFileReport();
        }
        return n;
    }

    protected IDfCollection execQuery(String string, int n) throws DfException {
        IDfCollection iDfCollection = null;
        DfQuery dfQuery = new DfQuery();
        dfQuery.setDQL(string);
        iDfCollection = dfQuery.execute(this.m_session, n);
        return iDfCollection;
    }

    public int setJobStatus(String string, Boolean bl) throws DfException {
        IDfCollection iDfCollection = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("update dm_job object set is_inactive=");
        if (bl.booleanValue()) {
            stringBuffer.append("1 ");
        } else {
            stringBuffer.append("0");
        }
        stringBuffer.append(" where method_name = '" + string + "'");
        this.logger.info("setJobStatus " + stringBuffer.toString());
        iDfCollection = this.execQuery(stringBuffer.toString(), 1);
        if (iDfCollection != null) {
            if (iDfCollection.next()) {
                n = 1;
            }
            iDfCollection.close();
        }
        return n;
    }

    public Boolean getFTIEnabled() throws DfException {
        IDfCollection iDfCollection = null;
        String string = "select count(*) as num from dm_fulltext_index;";
        if (this.m_fti_enabled == -1 && (iDfCollection = this.execQuery(string, 0)) != null) {
            if (iDfCollection.next()) {
                this.m_fti_enabled = iDfCollection.getInt("num");
            }
            iDfCollection.close();
        }
        return this.m_fti_enabled > 0;
    }

    public Boolean isDistributed() throws DfException {
        IDfCollection iDfCollection = null;
        String string = "select count(*) as num from dm_store where store_type=4;";
        if (this.m_dsa == -1 && (iDfCollection = this.execQuery(string, 0)) != null) {
            if (iDfCollection.next()) {
                this.m_dsa = iDfCollection.getInt("num");
            }
            iDfCollection.close();
        }
        return this.m_dsa > 0;
    }

    public int registerDbTables() {
        int n = 0;
        String[] stringArray = new String[]{"dm_sysobject_s", "dm_sysobject_r", "dm_folder_r", "dmr_content_s", "dmr_content_r"};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.registerDbTable(stringArray[i]).booleanValue()) continue;
                n = 1;
                break;
            }
        }
        catch (DfException dfException) {
            String string = "Registering Tables Failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            n = 1;
        }
        return n;
    }

    public Boolean registerDbTable(String string) throws DfException {
        IDfCollection iDfCollection = null;
        String string2 = "select r_object_id from dm_registered where table_name='" + string + "'";
        Boolean bl = false;
        iDfCollection = this.execQuery(string2, 0);
        if (iDfCollection != null) {
            if (iDfCollection.next()) {
                bl = true;
            }
            iDfCollection.close();
        }
        if (!bl.booleanValue() && (iDfCollection = this.execQuery(string2 = "register table dm_dbo." + string + "(dummy integer)", 1)) != null) {
            if (iDfCollection.next()) {
                bl = true;
            }
            iDfCollection.close();
        }
        return bl;
    }

    public Boolean getSessionProperties() {
        Boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer(8);
            this.m_version = this.m_session.getServerVersion();
            this.m_dbType = this.m_session.getDBMSName();
            this.m_docbaseId = Integer.toHexString(Integer.parseInt(this.m_session.getDocbaseId()));
            for (int i = 0; i < 8; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.replace(8 - this.m_docbaseId.length(), 8, this.m_docbaseId);
            this.m_docbaseId = stringBuffer.toString();
            bl = true;
            this.logger.info("docbase name " + this.m_docbaseName);
            this.logger.info("docbase version " + this.m_version);
            System.out.println("docbase=" + this.m_docbaseName + "|" + this.m_version + "|" + this.m_docbaseId);
        }
        catch (DfException dfException) {
            String string = "getSessionProperties Failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
            bl = false;
        }
        return bl;
    }

    public Boolean connectToDocbase() {
        Boolean bl = false;
        try {
            IDfClient iDfClient = DfClient.getLocalClient();
            DfLoginInfo dfLoginInfo = new DfLoginInfo();
            dfLoginInfo.setUser(this.m_userName);
            dfLoginInfo.setPassword(this.m_userPasswd);
            dfLoginInfo.setDomain(this.m_userDomain);
            this.m_session = iDfClient.newSession(this.m_docbaseName, (IDfLoginInfo)dfLoginInfo);
            if (this.m_session.isConnected()) {
                bl = true;
            }
        }
        catch (DfException dfException) {
            System.out.println("\nError: connectToDocbase():" + dfException.toString());
            String string = "connectToDocbase Failed " + dfException.toString();
            this.logger.severe(string);
            this.setErrorMsg(string);
        }
        return bl;
    }

    protected boolean disconnectFromDocbase() {
        Boolean bl = false;
        try {
            if (this.m_session.isConnected()) {
                this.m_session.disconnect();
                if (!this.m_session.isConnected()) {
                    bl = true;
                } else {
                    System.out.println("Error: disconnectFromDocbase(): the disconnect failed for some unknown reason!");
                }
            } else {
                System.out.println("Warning: disconnectFromDocbase(): no session to disconnect!");
            }
        }
        catch (DfException dfException) {
            System.out.println("\nError: disconnectFromDocbase():" + dfException.toString());
        }
        return bl;
    }

    public Boolean validateSAList() {
        return true;
    }

    public Boolean checkinVersion(IDfId iDfId, DocumentAttributes documentAttributes, String string) {
        Boolean bl = true;
        try {
            DfClientX dfClientX = new DfClientX();
            IDfSysObject iDfSysObject = (IDfSysObject)this.m_session.getObject(iDfId);
            IDfCheckinOperation iDfCheckinOperation = dfClientX.getCheckinOperation();
            if (!iDfSysObject.isCheckedOut()) {
                System.err.println("\nWarning: the object/virtual document is not checked out!");
                System.err.println("Checkin Operation failed!");
                bl = false;
            } else {
                int n = this.m_parser.getCheckinMethod();
                int n2 = 2;
                if (n == 1) {
                    n2 = 1;
                } else if (n == 2) {
                    n2 = 0;
                }
                IDfCheckinNode iDfCheckinNode = null;
                if (iDfSysObject.isVirtualDocument()) {
                    IDfVirtualDocument iDfVirtualDocument = iDfSysObject.asVirtualDocument("", false);
                    iDfCheckinNode = (IDfCheckinNode)iDfCheckinOperation.add((Object)iDfVirtualDocument);
                    iDfCheckinNode.setCheckinVersion(n2);
                } else {
                    iDfCheckinNode = (IDfCheckinNode)iDfCheckinOperation.add((Object)iDfSysObject);
                    iDfCheckinNode.setCheckinVersion(n2);
                    iDfCheckinNode.setVersionLabels(",CURRENT");
                    iDfCheckinNode.setFilePath(string);
                    iDfCheckinNode.setKeepLocalFile(false);
                    iDfCheckinNode.setFormat(documentAttributes.getFormat());
                }
                if (!iDfCheckinOperation.execute()) {
                    System.out.println("\nCheckin Operation failed!");
                    bl = false;
                } else {
                    if (!this.m_redirectRestore.booleanValue()) {
                        this.setCreationdate(documentAttributes.getLastModTime(), iDfCheckinNode.getNewObjectId());
                    }
                    iDfCheckinNode.getNewObject().setOwnerName(documentAttributes.getOwner());
                    System.out.println("\nCheckin Operation successful!");
                }
            }
        }
        catch (DfException dfException) {
            String string2 = "Error: executeCheckinOperation():  " + dfException.toString();
            this.logger.severe(string2);
            this.setErrorMsg(string2);
        }
        return bl;
    }

    void createCabinet(String string) throws DfException {
        try {
            IDfSysObject iDfSysObject = (IDfSysObject)this.m_session.newObject("dm_cabinet");
            iDfSysObject.setObjectName(string);
            iDfSysObject.setSubject("Created by CVRestore");
            iDfSysObject.save();
        }
        catch (DfException dfException) {
            String string2 = "Exceptton  while createCabinet  : = " + dfException.toString();
            this.logger.severe(string2);
            this.setErrorMsg(string2);
        }
    }

    void createFolder(String string, String string2) throws DfException {
        try {
            IDfSysObject iDfSysObject = (IDfSysObject)this.m_session.newObject("dm_folder");
            iDfSysObject.setObjectName(string);
            iDfSysObject.setSubject("CVRestore");
            iDfSysObject.link(string2);
            iDfSysObject.save();
        }
        catch (DfException dfException) {
            String string3 = "Exceptton  while createFolder  :  " + string + dfException.toString();
            this.logger.severe(string3);
            this.setErrorMsg(string3);
        }
    }

    Boolean checkFolderPathExists(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Select object_name from dm_sysobject where folder('" + string + "')");
        IDfCollection iDfCollection = null;
        Boolean bl = true;
        if (string2 != null) {
            stringBuffer.append(" and object_name like '" + string2 + "'");
        }
        try {
            this.logger.info(" query " + stringBuffer.toString());
            iDfCollection = this.execQuery(stringBuffer.toString(), 4);
            if (iDfCollection != null) {
                bl = iDfCollection.next() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                iDfCollection.close();
            } else {
                bl = false;
            }
        }
        catch (DfException dfException) {
            String string3 = "Exceptton  while checkFolderPathExists  : = " + dfException.toString();
            this.logger.severe(string3);
            this.setErrorMsg(string3);
            bl = false;
        }
        return bl;
    }

    Boolean createFolderPath(String string) {
        int n = 0;
        int n2 = 0;
        Boolean bl = true;
        String string2 = "";
        String string3 = "";
        System.out.println(" createFolderPath " + string);
        while (n < string.length() && (n2 = string.indexOf(47, n + 1)) > 0) {
            try {
                if (n == 0) {
                    n = n2;
                    string2 = string.substring(0, n);
                    this.logger.info("createFolderPath cabinet " + string2);
                    if (!this.checkFolderPathExists(string2, null).booleanValue()) {
                        this.logger.info("create cabinet " + string2);
                        this.createCabinet(string2.substring(1));
                    }
                } else {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1, n2);
                    this.logger.info("createFolderPath folderPath " + string2 + " name " + string3);
                    if (!this.checkFolderPathExists(string2, string3).booleanValue()) {
                        this.logger.info("create folder " + string2 + "/" + string3);
                        this.createFolder(string3, string2);
                    }
                }
            }
            catch (DfException dfException) {
                String string4 = "Exceptton  while createFolderPath : = " + string + " " + dfException.toString();
                this.logger.severe(string4);
                this.setErrorMsg(string4);
                bl = false;
            }
            n = n2;
        }
        return bl;
    }

    Boolean setCreationdate(String string, IDfId iDfId) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("update dm_document OBJECT set r_creation_date=Date('");
        stringBuffer.append(string);
        stringBuffer.append("') where r_object_id='");
        stringBuffer.append(iDfId).append("';");
        IDfCollection iDfCollection = null;
        Boolean bl = true;
        try {
            iDfCollection = this.execQuery(stringBuffer.toString(), 4);
            if (iDfCollection != null) {
                iDfCollection.close();
            }
        }
        catch (DfException dfException) {
            String string2 = "Exceptton  while setting the creation date  : = " + dfException.toString();
            this.logger.severe(string2);
            this.setErrorMsg(string2);
            bl = false;
        }
        return bl;
    }

    public Boolean runSingleVersionRestore(String string, String string2, DocumentAttributes documentAttributes) {
        Object object;
        String string3;
        int n = string.indexOf(47, 0);
        int n2 = string.lastIndexOf(47);
        IDfCollection iDfCollection = null;
        Boolean bl = true;
        Boolean bl2 = false;
        String string4 = "";
        String string5 = "";
        if (this.m_restoreDestPath != null && !this.m_restoreDestPath.equals("")) {
            string3 = !string.equals(string2) ? this.m_restoreDestPath + string.substring(string2.length(), n2) : this.m_restoreDestPath;
            this.m_redirectRestore = true;
        } else {
            string3 = string.substring(n, n2);
        }
        String string6 = string.substring(n2 + 1);
        this.logger.info("Restore doc_name = " + string6 + " destination folder " + string3);
        if (!string3.endsWith("/")) {
            this.createFolderPath(string3.concat("/"));
        } else {
            this.createFolderPath(string3);
        }
        Vector<String> vector = documentAttributes.getSaFileList();
        int n3 = 0;
        int n4 = 0;
        while (n3 < vector.size()) {
            int n5;
            string4 = vector.elementAt(n3).trim();
            n4 = Integer.parseInt(string4.substring((n5 = string4.lastIndexOf(124)) + 1));
            if (n4 != 0) {
                this.logger.info("this entry represents rendition.  skipping");
                ++n3;
                continue;
            }
            string5 = string4.substring(string4.indexOf(FILE_SEP, 1), n5);
            if (CvDctm.isWindows()) {
                string5 = string5.replace(":", "");
            }
            if (((File)(object = new File(string5 = this.m_parser.getSAFilesRestoreDestination() + string5))).exists()) {
                this.logger.info("doc_name = " + string6 + " version = " + documentAttributes.getVersion() + " physical file = " + string5);
                break;
            }
            this.logger.severe("physical path is  exists " + string5);
            string5 = "";
            ++n3;
        }
        if (string5.equals("")) {
            object = "No physical SA Files located on this client for doc name " + string6 + " version " + documentAttributes.getVersion();
            this.logger.severe((String)object);
            this.setErrorMsg((String)object);
            if (n4 == 0) {
                return false;
            }
            return true;
        }
        try {
            object = "select s.r_object_id, s.object_name from dm_sysobject s, dm_sysobject_r sr, dm_folder_r fr  where sr.r_object_id = s.r_object_id and fr.r_object_id = sr.i_folder_id and fr.i_position = -1 and fr.r_folder_path ='" + string3 + "' and object_name='" + string6 + "'";
            System.out.println("query string = " + (String)object);
            iDfCollection = this.execQuery((String)object, 4);
            if (iDfCollection != null && iDfCollection.next()) {
                bl2 = true;
            }
        }
        catch (DfException dfException) {
            System.out.println("\n Exception : " + dfException.toString());
            this.logger.info("Document does not exist. Recreate it  " + string);
        }
        if (bl2.booleanValue()) {
            try {
                object = iDfCollection.getId("r_object_id");
                IDfSysObject iDfSysObject = (IDfSysObject)this.m_session.getObject((IDfId)object);
                if (!iDfSysObject.isCheckedOut()) {
                    iDfSysObject.checkout();
                } else {
                    System.out.println("\n Document already Checked out " + string6);
                }
                bl = this.checkinVersion((IDfId)object, documentAttributes, string5);
                iDfCollection.close();
            }
            catch (DfException dfException) {
                this.logger.severe("\n Exceptton  while looking up document :" + dfException.toString());
                bl = false;
            }
        } else {
            try {
                object = (IDfSysObject)this.m_session.newObject("dm_document");
                object.setObjectName(string6);
                object.setContentType(documentAttributes.getFormat());
                object.setOwnerName(documentAttributes.getOwner());
                object.setFile(string5);
                object.link(string3);
                object.save();
            }
            catch (DfException dfException) {
                System.out.println("\n Exceptton :" + dfException.toString());
                String string7 = "Exceptton while creation new document  ' " + string6 + "' " + dfException.toString();
                this.logger.severe(string7);
                this.setErrorMsg(string7);
                bl = false;
            }
        }
        return bl;
    }

    public Boolean runSingleDocRestore(ListAllVersions listAllVersions) {
        Boolean bl = true;
        this.m_restoreDestPath = this.m_parser.getRestoreDestination();
        if (listAllVersions != null) {
            List<DocumentAttributes> list = listAllVersions.getDocVersions();
            String string = listAllVersions.getDocName();
            String string2 = listAllVersions.getDocSrcPath();
            this.logger.info("runSingleDocRestore - docName = " + string + " end");
            if (list != null) {
                ListIterator<DocumentAttributes> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    listIterator.next();
                }
                while (listIterator.hasPrevious()) {
                    if (this.runSingleVersionRestore(string, string2, listIterator.previous()).booleanValue()) continue;
                    bl = false;
                }
            } else {
                System.out.println("runSingleDocRestore - No Versions sent for Restore");
            }
        }
        return bl;
    }

    public String readXMLInput(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = "";
        try {
            fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            string2 = stringBuffer.toString();
            fileInputStream.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "runRestore failed " + fileNotFoundException.toString();
            this.logger.severe(string3);
            this.setErrorMsg(string3);
        }
        catch (IOException iOException) {
            String string4 = "runRestore IOException = " + iOException.toString();
            this.logger.severe(string4);
            this.setErrorMsg(string4);
        }
        return string2;
    }

    public int runRestore() {
        String string = this.m_parser.getRestoreXMLFile();
        int n = 0;
        this.logger.info("runRestore Enter: xmlFile = " + string);
        String string2 = this.readXMLInput(string);
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                String string3;
                ListAllVersions listAllVersions;
                if ((n3 = string2.indexOf(CvDctm.getDocViewPrefixPath(), n2 + 1)) == -1) {
                    n3 = string2.length();
                }
                if (!this.runSingleDocRestore(listAllVersions = new ListAllVersions(string3 = string2.substring(n2, n3))).booleanValue()) {
                    this.logger.severe("runRestore Failed to create Documentum Entries ");
                    n = 1;
                }
                n2 = n3;
            } while (n3 > 0 && n3 < string2.length());
        }
        catch (Exception exception) {
            String string4 = "runRestore Exception = " + exception.toString();
            this.logger.severe(string4);
            this.setErrorMsg(string4);
            exception.printStackTrace();
            n = 1;
        }
        this.logger.info("runRestore return = " + n);
        return n;
    }

    public static void main(String[] stringArray) {
        CvDctm cvDctm = new CvDctm();
        int n = cvDctm.runAction(stringArray);
        cvDctm.disconnectFromDocbase();
        System.exit(n);
    }
}

