/*
 * Decompiled with CFR 0.152.
 */
package cvdctm;

class CmdParser {
    Boolean m_discover = false;
    Boolean m_prebackup = false;
    Boolean m_postbackup = false;
    Boolean m_scanphase = false;
    Boolean m_prerestore = false;
    Boolean m_postrestore = false;
    Boolean m_filereport = false;
    Boolean m_fti_selected = false;
    Boolean m_sa_selected = false;
    Boolean m_full_selection = false;
    Boolean m_include_reportfiles = false;
    Boolean m_restore = false;
    private String m_repo_name = null;
    private String[] m_ftiList = null;
    private String[] m_saList = null;
    private int m_checkin_fileas = 0;
    private String m_user_nm = null;
    private String m_user_passwd = null;
    private String m_user_domain = "";
    static final String FILE_SEP = System.getProperty("file.separator");
    int m_bkp_level = 0;

    public int parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("discover")) {
                this.m_discover = true;
                continue;
            }
            if (stringArray[i].equals("prebackup")) {
                this.m_discover = true;
                this.m_prebackup = true;
                continue;
            }
            if (stringArray[i].equals("postbackup")) {
                this.m_postbackup = true;
                continue;
            }
            if (stringArray[i].equals("scanphase")) {
                this.m_scanphase = true;
                continue;
            }
            if (stringArray[i].equals("prerestore")) {
                this.m_prerestore = true;
                continue;
            }
            if (stringArray[i].equals("postrestore")) {
                this.m_postrestore = true;
                continue;
            }
            if (stringArray[i].equals("filereport")) {
                this.m_filereport = true;
                continue;
            }
            if (stringArray[i].equals("reports")) {
                this.m_include_reportfiles = true;
                continue;
            }
            if (stringArray[i].equals("restore")) {
                this.m_restore = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-i")) {
                this.m_repo_name = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-t")) {
                this.m_bkp_level = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-sa")) {
                this.m_sa_selected = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-u")) {
                this.m_user_nm = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-p")) {
                this.m_user_passwd = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-d")) {
                this.m_user_domain = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-fti")) {
                String string = stringArray[++i];
                this.m_ftiList = string.split(",");
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-checkinas")) continue;
            this.m_checkin_fileas = Integer.parseInt(stringArray[++i]);
        }
        if (!this.m_fti_selected.booleanValue() && !this.m_sa_selected.booleanValue()) {
            this.m_full_selection = true;
        }
        return 0;
    }

    public String getDocBaseName() {
        return this.m_repo_name;
    }

    public String getEnv(String string) {
        return System.getenv(string);
    }

    public Boolean getDiscover() {
        return this.m_discover;
    }

    public Boolean getRestore() {
        System.out.println("Returning m_restore = " + this.m_restore);
        return this.m_restore;
    }

    public Boolean getPreBackup() {
        return this.m_prebackup;
    }

    public Boolean getPostBackup() {
        return this.m_postbackup;
    }

    public Boolean getScanPhase() {
        return this.m_scanphase;
    }

    public Boolean getPreRestore() {
        return this.m_prerestore;
    }

    public Boolean getPostRestore() {
        return this.m_postrestore;
    }

    public Boolean getFileReport() {
        return this.m_filereport;
    }

    public Boolean getFTISelected() {
        return this.m_full_selection != false || this.m_fti_selected != false;
    }

    public Boolean getSASelected() {
        return this.m_sa_selected;
    }

    public Boolean getIncludeReports() {
        return this.m_include_reportfiles;
    }

    public String[] getSAList() {
        String string;
        if (this.m_saList == null && (string = this.getEnv("CVDCTM_SALIST")) != null) {
            this.m_saList = string.split(",");
        }
        return this.m_saList;
    }

    public String[] getFTIList() {
        return this.m_ftiList;
    }

    public String getUserName() {
        if (this.m_user_nm == null) {
            this.m_user_nm = this.getEnv("CVDCTM_USER_NAME");
            if (this.m_user_nm == null) {
                this.m_user_nm = "";
            }
        }
        return this.m_user_nm;
    }

    public String getPasswd() {
        if (this.m_user_passwd == null) {
            this.m_user_passwd = this.getEnv("CVDCTM_USER_PASSWD");
            if (this.m_user_passwd == null) {
                this.m_user_passwd = "";
            }
        }
        return this.m_user_passwd;
    }

    public String getUserDomain() {
        if (this.m_user_domain == null) {
            this.m_user_domain = this.getEnv("CVDCTM_USER_DOMAIN");
            if (this.m_user_domain == null) {
                this.m_user_domain = "";
            }
        }
        return this.m_user_domain;
    }

    public String getJobResults() {
        String string = this.getEnv("CVDCTM_JOBRESULTS");
        if (string == null) {
            string = "";
        } else if (!string.endsWith(FILE_SEP)) {
            string = string + FILE_SEP;
        }
        return string;
    }

    public String getResponseFile() {
        String string = this.getEnv("CVDCTM_RESPONSE");
        string = string != null ? string + ".rsp" : "cvdctm.rsp";
        return this.getJobResults() + string;
    }

    public String getSplitDctm() {
        String string = this.getEnv("CVDCTM_SPLITDCTM_CONFIG");
        return string;
    }

    public String getSAFilesRestoreDestination() {
        String string = this.getEnv("CVDCTM_SAFILES_RESTORE_DESTPATH");
        return string;
    }

    public String getRestoreDestination() {
        String string = this.getEnv("CVDCTM_RESTORE_DESTPATH");
        return string;
    }

    public String getRestoreXMLFile() {
        String string = "cvdctmrst.xml";
        return this.getJobResults() + string;
    }

    public String getErrMsgFile() {
        String string = this.getEnv("CVDCTM_RESPONSE");
        string = string != null ? string + ".err" : "cvdctm.err";
        return this.getJobResults() + string;
    }

    public String getReportFile() {
        String string = this.getEnv("CVDCTM_RESPONSE");
        string = string != null ? string + ".rpt" : "cvdctm.rpt";
        return this.getJobResults() + string;
    }

    public int getCheckinMethod() {
        return this.m_checkin_fileas;
    }

    public String getLogFile() {
        String string = this.getEnv("CVDCTM_LOGFILE");
        if (string != null) {
            if (!string.endsWith(FILE_SEP)) {
                string = string + FILE_SEP;
            }
            string = string + "cvdctm.log";
        } else {
            string = "cvdctm.log";
        }
        return string;
    }

    public int getBkpLevel() {
        return this.m_bkp_level;
    }

    public static void main(String[] stringArray) {
        CmdParser cmdParser = new CmdParser();
        cmdParser.parseArgs(stringArray);
        if (cmdParser.getPreBackup().booleanValue()) {
            System.out.println("Prebackup phase ");
            String[] stringArray2 = cmdParser.getSAList();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("SA selected for Backup " + stringArray2[i]);
            }
        }
    }
}

