/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.certutil;

import commvault.cte.certutil.KeytoolAction;
import commvault.cte.certutil.StreamGobbler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CertificateUtil {
    private static String LOG_FILE_PREFIX = "cvcertutil_";
    private ExecutorService threadpool = Executors.newCachedThreadPool();
    private File certificateFolder;
    private File keytoolFile;
    private File certStore;
    private String storepass;

    public static void main(String[] stringArray) {
        boolean bl;
        File file;
        File file2;
        Object object;
        Serializable serializable;
        KeytoolAction keytoolAction;
        System.out.println();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("arg[" + i + "]: " + stringArray[i]);
            }
            System.out.println();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) continue;
            if (stringArray[i].equalsIgnoreCase("-importfolder")) {
                string = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-jrefolder")) {
                string2 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-action")) {
                string3 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-storepass")) {
                string4 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-certstore")) {
                string5 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-logfolder")) {
                string6 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-maxlogfiles")) {
                string7 = CertificateUtil.getArgValue(stringArray, i + 1);
                ++i;
                continue;
            }
            System.out.println("unknown argument [" + stringArray[i] + "]\n");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = System.getProperty("java.home");
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "import";
        }
        if ((keytoolAction = KeytoolAction.fromString(string3)) == null) {
            System.out.println("invalid value for argument -action");
            System.exit(1);
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "changeit";
        }
        int n = 0;
        if (string7 != null && string7.length() > 0) {
            try {
                n = Integer.parseInt(string7);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("invalid int value for argument maxlogfiles");
            }
        }
        if (n == 0) {
            n = 5;
        }
        File file3 = string6 == null || string6.length() == 0 ? new File("./") : new File(string6);
        CertificateUtil.validateFolder("log", file3);
        CertificateUtil.cleanupLogs(file3, n);
        FileOutputStream fileOutputStream = null;
        try {
            serializable = new SimpleDateFormat("yyyy'_'MM'_'dd'_'HH'_'mm'_'ss");
            object = String.format(LOG_FILE_PREFIX + "%s.log", ((DateFormat)serializable).format(new Date()));
            file2 = new File(file3, (String)object);
            System.out.println("logging to " + file2.getAbsolutePath());
            fileOutputStream = new FileOutputStream(file2);
            PrintStream printStream = new PrintStream((OutputStream)fileOutputStream, true, "UTF-8");
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = null;
        if (string == null || string.length() == 0) {
            try {
                serializable = new File(CertificateUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                System.exit(1);
            }
        } else {
            serializable = new File(string);
        }
        CertificateUtil.validateFolder("certificate import", (File)serializable);
        object = new File(string2);
        CertificateUtil.validateFolder("JRE", (File)object);
        file2 = string5 != null && string5.length() > 0 ? new File(string5) : new File((File)object, "lib/security/cacerts");
        if (!file2.exists()) {
            System.err.println("could not find JRE certificate store: [" + file2.getAbsolutePath() + "]");
            System.exit(1);
        }
        if (!(file = new File((File)object, (bl = System.getProperty("os.name").startsWith("Windows")) ? "bin/keytool.exe" : "bin/keytool")).exists()) {
            System.err.println("could not find JRE keytool executable: [" + file.getAbsolutePath() + "]");
            System.exit(1);
        }
        System.out.println("Certificate Folder: " + ((File)serializable).getAbsolutePath());
        System.out.println("Certificate Store: " + file2.getAbsolutePath());
        System.out.println();
        CertificateUtil certificateUtil = new CertificateUtil((File)serializable, file, file2, string4);
        try {
            certificateUtil.doWork(keytoolAction);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
        if (fileOutputStream != null) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void validateFolder(String string, File file) {
        if (!file.exists()) {
            System.err.println(string + " folder [" + file.getAbsolutePath() + "] does not exist");
            System.exit(1);
        }
        if (!file.isDirectory()) {
            System.err.println(string + " folder [" + file.getAbsolutePath() + "] is not a valid directory");
            System.exit(1);
        }
    }

    private static void cleanupLogs(File file, int n) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().startsWith(LOG_FILE_PREFIX) && string.toLowerCase().endsWith(".log");
            }
        };
        List<File> list = Arrays.asList(file.listFiles(filenameFilter));
        if (list.size() <= n) {
            return;
        }
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return Long.compare(file.lastModified(), file2.lastModified());
            }
        });
        for (int i = 0; i < list.size() - n; ++i) {
            File file2 = list.get(i);
            System.out.println("deleting log file [" + file2.getName() + "]");
            try {
                file2.delete();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        System.out.println();
    }

    private static String getArgValue(String[] stringArray, int n) {
        String string;
        if (stringArray.length > n && !(string = stringArray[n].trim()).startsWith("-")) {
            return string;
        }
        return null;
    }

    public CertificateUtil(File file, File file2, File file3, String string) {
        this.certificateFolder = file;
        this.keytoolFile = file2;
        this.certStore = file3;
        this.storepass = string;
    }

    public void doWork(KeytoolAction keytoolAction) throws Exception {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".cer");
            }
        };
        File[] fileArray = this.certificateFolder.listFiles(filenameFilter);
        if (fileArray.length > 0) {
            String string;
            if (keytoolAction == KeytoolAction.IMPORT) {
                System.out.println("importing certificates from folder [" + this.certificateFolder.getAbsolutePath() + "] into certificate store file [" + this.certStore.getAbsolutePath() + "]");
                for (File file : fileArray) {
                    string = this.buildImportCommand(file);
                    this.executeCommand(file, string);
                }
            }
            if (keytoolAction == KeytoolAction.REMOVE) {
                System.out.println("removing certificates in folder [" + this.certificateFolder.getAbsolutePath() + "] from certificate store file [" + this.certStore.getAbsolutePath() + "]");
                for (File file : fileArray) {
                    string = this.buildDeleteCommand(file);
                    this.executeCommand(file, string);
                }
            }
        } else {
            System.out.println("found no .cer files in import folder [" + this.certificateFolder.getAbsolutePath() + "]");
        }
        System.out.println();
        this.threadpool.shutdown();
    }

    private void executeCommand(File file, String string) throws Exception {
        System.out.println();
        System.out.println("************************* [" + file.getName() + "] *************************");
        System.out.println("executing command: " + string);
        System.out.println();
        Process process = Runtime.getRuntime().exec(string);
        this.threadpool.submit(new StreamGobbler(process.getInputStream(), System.out::println));
        this.threadpool.submit(new StreamGobbler(process.getErrorStream(), System.err::println));
        int n = process.waitFor();
        process.getInputStream().close();
        process.getOutputStream().close();
        process.getErrorStream().close();
        if (n != 0) {
            System.out.println();
            System.err.println("command failed with error code [" + n + "]");
        }
    }

    private String buildDeleteCommand(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(this.keytoolFile.getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append("-delete ");
        stringBuilder.append("-keystore \"");
        stringBuilder.append(this.certStore.getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append("-storepass \"");
        stringBuilder.append(this.storepass);
        stringBuilder.append("\" ");
        stringBuilder.append("-alias \"");
        stringBuilder.append(this.getFileNameWithoutExtension(file));
        stringBuilder.append("\" ");
        return stringBuilder.toString();
    }

    private String buildImportCommand(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(this.keytoolFile.getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append("-import ");
        stringBuilder.append("-trustcacerts ");
        stringBuilder.append("-noprompt ");
        stringBuilder.append("-keystore \"");
        stringBuilder.append(this.certStore.getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append("-storepass \"");
        stringBuilder.append(this.storepass);
        stringBuilder.append("\" ");
        stringBuilder.append("-alias \"");
        stringBuilder.append(this.getFileNameWithoutExtension(file));
        stringBuilder.append("\" ");
        stringBuilder.append("-file \"");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("\" ");
        return stringBuilder.toString();
    }

    private String getFileNameWithoutExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }
}

