# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""" All the Web SLA Reports page. """

from Web.Common.page_object import (
    WebAction,
    PageService
)


class WebSla:
    """Class to interact with WEB SLA page"""
    def __init__(self, webconsole):
        """
        Args:
           webconsole (WebConsole): The webconsole object to use
        """
        self._webconsole = webconsole
        self._driver = webconsole.browser.driver

    @WebAction()
    def _click_text(self, text):
        """
        Clicks on chart category
        Args:
            text: Chart category text
        """
        chart_category = "//*[name()='tspan' and contains(text(), '" + text + "')]"
        self._driver.find_element_by_xpath(chart_category).click()

    @PageService()
    def access_missed_sla(self):
        """
        Drill down on missed sla in Chart
        """
        self._click_text('Missed SLA')
        self._webconsole.wait_till_load_complete()

    @PageService()
    def access_met_sla(self):
        """
        Drill down on sla in Chart
        """
        self._click_text('Met SLA')
        self._webconsole.wait_till_load_complete()

    @PageService()
    def access_failed_clients(self):
        """
        Drill down on sla in Chart
        """
        self._click_text('Failed')
        self._webconsole.wait_till_load_complete()


    @PageService()
    def access_no_schedule_clients(self):
        """
        Drill down on sla in Chart
        """
        self._click_text('No Schedule')
        self._webconsole.wait_till_load_complete()



    @PageService()
    def access_no_job_clients(self):
        """
        Drill down on sla in Chart
        """
        self._click_text('No Job')
        self._webconsole.wait_till_load_complete()


    @PageService()
    def access_snap_with_nobackupcopy_clients(self):
        """
        Drill down on sla in Chart
        """
        self._click_text('Snap Job with ')
        self._webconsole.wait_till_load_complete()


    @WebAction()
    def _get_sla_txt(self):
        """Read the text for SLA Panel"""
        return self._driver.find_element_by_id('slaPercent').text


    @PageService()
    def get_sla(self):
        """
        Clicks on chart category
        Args:
            text: Chart category text
        """
        sla_text = self._get_sla_txt()
        return sla_text.split("SLA is ")[1]
