# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This module provides method virtual files machine restores.


Classes:

    GuestFilesRestoreSelectVolume() ---> AdminPage() ---> AdminConsoleBase() ---> Object()

    GuestFilesRestoreSelectVolume --  This class contains methods for submitting virtual
                                    files machine restores.

    Functions:

    select_volume() -- Opens the drives of the backed up VM to browse content

"""
from Web.Common.page_object import WebAction
from Web.AdminConsole.VSAPages.restore_select_vm import RestoreSelectVM


class GuestFilesRestoreSelectVolume:
    """
    This class contains methods for submitting virtual files machine restores.
    """
    def __init__(self, admin_console):
        """
        Init method to create objects of classes used in the file.
        """
        self.__admin_console = admin_console
        self.__admin_console._load_properties(self)
        self.__driver = admin_console.driver
        self.res_select_vm_obj = RestoreSelectVM(admin_console)

    @WebAction()
    def select_volume(self, vm_name, vol):
        """
        Opens the drives of the backed up VM to browse content

        Args:
            vm_name (basestring): vm name to be selected
            vol (basestring)    : volume to be selected
        """
        if not self.__admin_console.check_if_entity_exists(
                "xpath", "//div[1]/ul/li[1]/span[contains(text(),'" + vm_name + "')]"):
            self.res_select_vm_obj.select_vm(vm_name)
        self.__admin_console.log.info("Opening volume %s", vol)
        if "/" in vol:
            folder_to_browse = vol.split("/")[1:]
            if not folder_to_browse[0]:
                return
        else:
            folder_to_browse = [vol]
        for folder in folder_to_browse:
            while True:
                if not self.__admin_console.check_if_entity_exists("xpath", "//a[@val='" + folder + "']"):
                    if self.__admin_console.cv_table_next_button_exists():
                        if self.__driver.find_element_by_xpath(
                                "//button[@ng-disabled='cantPageForward()']").is_enabled():
                            self.__admin_console.cv_table_click_next_button()
                            continue
                    else:
                        self.__admin_console.log.error("{} not found".format(vol))
                        break
                self.__driver.find_element_by_xpath("//a[@val='" + folder + "']").click()
                self.__admin_console.wait_for_completion()
                break
