# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
"""
This module provides the function or operations that can be performed on the
admin console schedules page
"""

from Web.AdminConsole.Reports.cte import CommonFeatures
from Web.Common.page_object import PageService


class ManageSchedules(CommonFeatures):
    """Class for managing report's schedules"""

    @PageService()
    def enable_schedules(self, schedules):
        """
        Enable Schedules
        Args:
            schedules              (list)     -- List of schedules
        """
        self.enable_entity(schedules)
        self._admin_console.wait_for_completion()

    @PageService()
    def disable_schedules(self, schedules):
        """
        Disable Schedules
        Args:
            schedules              (list)     -- List of schedules
        """
        self.disable_entity(schedules)
        self._admin_console.wait_for_completion()

    @PageService()
    def run_schedules(self, schedules):
        """
        run schedules
        Args:
            schedules              (list)     -- List of schedules
        """
        self.run_entity(schedules)
        self._admin_console.wait_for_completion()

    @PageService()
    def delete_schedules(self, schedules):
        """
        Delete Schedules
        Args:
            schedules              (list)     -- List of schedules
        """
        self.delete_entity(schedules)
        self._admin_console.wait_for_completion()
