# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
"""
This module provides the function or operations that can be performed on the
admin console alerts page
"""

from Web.AdminConsole.Reports.cte import CommonFeatures
from Web.Common.page_object import (
    PageService,
    WebAction
)


class ManageAlerts(CommonFeatures):
    """Class for managing report's alerts"""

    @WebAction()
    def __get_alert_names(self):
        """Returns the list of all alerts"""
        return [alert.text for alert in self._driver.find_elements_by_xpath("//td//a")]

    @PageService()
    def enable_alerts(self, alerts):
        """
        Enable alerts
        Args:
            alerts              (list)     -- List of alerts
        """
        self.enable_entity(alerts)
        self._admin_console.wait_for_completion()

    @PageService()
    def disable_alerts(self, alerts):
        """
        Disable alerts
        Args:
            alerts              (list)     -- List of alerts
        """
        self.disable_entity(alerts)
        self._admin_console.wait_for_completion()

    @PageService()
    def run_alerts(self, alerts):
        """
        run alerts
        Args:
            alerts              (list)     -- List of alerts
        """
        self.run_entity(alerts)
        self._admin_console.wait_for_completion()

    @PageService()
    def delete_alerts(self, alerts):
        """
        Delete alerts
        Args:
            alerts              (list)     -- List of alerts
        """
        self.delete_entity(alerts)
        self._admin_console.wait_for_completion()
        
    @PageService()
    def get_all_alerts(self):
        """Fetches the list of all alerts"""
        return self.__get_alert_names()
