# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
Main file for all the constants of Office 365 Web Automation
"""

from enum import Enum


class OneDrive(Enum):
    """
    Enum class for declaring all constants of OneDrive
    """
    ACCOUNT_TAB = 'Users'
    CONTENT_TAB = 'Content'
    ADD_BUTTON_ID = 'ID_USER'
    ADD_USER_BUTTON_ID = 'ADD_USER'
    O365_PLAN_DROPDOWN_ID = 'office365OneDriveAddAssociation_isteven-multi-select_#5444'
    BACKUP_MENU_ID = 'BACKUP_GRID'
    USER_CHANGE_OFFICE365_PLAN_ID = 'office365OneDriveUsersTable_actionContextMenu_CHANGE_PLAN'
    GROUP_CHANGE_OFFICE365_PLAN_ID = 'office365OneDriveContentTable_actionContextMenu_CHANGE_PLAN'
    CLICK_RESTORE_ID = 'RESTORE_OPTIONS'
    ACCOUNT_RESTORE_XPATH = '//li[@id="batch-action-menu_RESTORE"]//a[@id="RESTORE"]'
    BROWSE_RESTORE_XPATH = '//li[@id="batch-action-menu_BROWSE"]//a[@id="BROWSE"]'
    EMAIL_ADDRESS_COLUMN_ID = 'cv-k-grid-td-URL'
    CONTENT_STATUS_COLUMN_ID = 'cv-k-grid-td-GROUP_STATUS'
    USERS_STATUS_COLUMN_ID = 'cv-k-grid-td-ACCOUNT_STATUS'
    USERS_MANAGE_ID = 'office365OneDriveUsersTable_actionContextMenu_MANAGE'
    USERS_DELETE_ID = 'office365OneDriveUsersTable_actionContextMenu_REMOVE'
    USERS_DISABLE_ID = 'office365OneDriveUsersTable_actionContextMenu_DISABLE'
    USERS_ENABLE_ID = 'office365OneDriveUsersTable_actionContextMenu_ENABLE'
    GROUP_MANAGE_ID = 'office365OneDriveContentTable_actionContextMenu_MANAGE'
    GROUP_DELETE_ID = 'office365OneDriveContentTable_actionContextMenu_REMOVE'
    GROUP_DISABLE_ID = 'office365OneDriveContentTable_actionContextMenu_DISABLE'
    GROUP_ENABLE_ID = 'office365OneDriveContentTable_actionContextMenu_ENABLE'

    DISCOVER_PROCESS_NAME = 'cvclouddiscoverv2'
    MAX_STREAMS_COUNT = '10'
    DOC_COUNT_FULL_BKP_JOB = 15
    DOC_COUNT_INCR_BKP_JOB = 5
    INFRA_POOL_MAX_STREAMS = '25'
    INFRA_POOL_INDEX_SERVER = 'IS_nandini-case1'
    INFRA_POOL_CLIENT_GROUP = 'NandiniAccessNodesGroup'
    INFRA_POOL_SHARED_DIR = '\\\\NANDINI-CASE1\\SharedDir\\JobResults'
    INFRA_POOL_SHARED_ACCOUNT = 'vayu\\Administrator'
    PIT_RESTORE_FOLDER_COUNT = 3  # User, My Drive and AutomationFolder
    FILTERS_RESTORE_FOLDER_COUNT = 2  # User and My Drive
    REFRESH_CACHE_USER_COUNT = 6
    SERVER_PLAN_NAME = 'Automation_ServerPlan_'
    STORAGE_DICT = {'pri_storage': '',
                    'pri_ret_period': '1',
                    'ret_unit': 'Month(s)'}
    RPO_DICT = {'hours': '',
                'minutes': '',
                'am_or_pm': ''}


class ExchangeOnline(Enum):
    """
    Enum class for declaring all constants on Exchange Online
    """
    ACCOUNT_TAB = 'Mailboxes'
    CONTENT_TAB = 'Content'
    ADD_BUTTON_ID = 'addMailbox'
    ADD_USER_BUTTON_ID = 'undefined'
    O365_PLAN_DROPDOWN_ID = 'exchangePlan_isteven-multi-select_#2'
    BACKUP_MENU_ID = 'ARCHIVE_GRID'
    USER_CHANGE_OFFICE365_PLAN_ID = 'exchangeMBListTable_actionContextMenu_ADD_PLAN'
    GROUP_CHANGE_OFFICE365_PLAN_ID = 'exchangeMBListTable_actionContextMenu_ADD_PLAN'
    CLICK_RESTORE_ID = 'RESTORE'
    ACCOUNT_RESTORE_XPATH = '//li[@id="batch-action-menu_RESTORE_MAILBOX"]//a[@id="RESTORE_MAILBOX"]'
    BROWSE_RESTORE_XPATH = '//li[@id="batch-action-menu_BROWSE"]//a[@id="BROWSE"]'
    ADD_MENU_ID = 'addAutoDiscover'
    MAX_STREAMS_COUNT = '10'
    EMAIL_ADDRESS_COLUMN_ID = 'cv-k-grid-td-EMAIL_ADDRESS'
    CONTENT_STATUS_COLUMN_ID = 'cv-k-grid-td-EMAIL_STATUS'
    USERS_STATUS_COLUMN_ID = 'cv-k-grid-td-EMAIL_STATUS'
    CREATE_OFFICE365_PLAN_BUTTON_ID = 'createOffice365Plan_button_#0103'
    USERS_MANAGE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_MANAGE']"
    USERS_DELETE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_DELETE']//a[@id='DELETE']"
    USERS_DISABLE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_DISABLE']//a[@id='DISABLE']"
    USERS_ENABLE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_ENABLE']//a[@id='ENABLE']"
    GROUP_MANAGE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_MANAGE']"
    GROUP_DELETE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_DELETE']//a[@id='DELETE']"
    GROUP_DISABLE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_DISABLE']//a[@id='DISABLE']"
    GROUP_ENABLE_ID = "//li[@id='exchangeMBListTable_actionContextMenu_ENABLE']//a[@id='ENABLE']"


class SharePointOnline(Enum):
    """
    Enum class for declaring all constants on SharePoint Online Pseudo Client
    """
    MAX_STREAMS_COUNT = '10'
    CONTENT_TAB = 'Content'


class StatusTypes(Enum):
    DELETED = 'Deleted'
    DISABLED = 'Disabled'
    ACTIVE = 'Active'


class RestoreType(Enum):
    TO_DISK = 'Restore to Disk'
    IN_PLACE = 'Restore to original location'
    OOP = 'Restore to different OneDrive account'


class O365PlanFilterType(Enum):
    INCLUDE = 'Include Files/Folders'
    EXCLUDE = 'Exclude Files/Folders'
