from Web.AdminConsole.AdminConsolePages.network_store import NetworkStore
from Web.AdminConsole.Components.table import Table


class NetworkStoreHelper:
    """Helper class for network store page"""

    def __init__(self, admin_console):

        self.__admin_console = admin_console
        self.__navigator = admin_console.navigator
        self.__driver = admin_console.driver
        self.log = self.__admin_console.log
        self.__table = Table(self.__admin_console)

        self._network_store_obj = NetworkStore(self.__admin_console)
        self._network_store_name = None
        self._nfs_server = None
        self._plan = None

    @property
    def network_store_name(self):
        """Method to get network store name"""
        return self._network_store_name

    @network_store_name.setter
    def network_store_name(self, value):
        """Method to set the network store name"""
        self._network_store_name = value

    @property
    def nfs_server(self):
        """Method to get nfs server"""
        return self._nfs_server

    @nfs_server.setter
    def nfs_server(self, value):
        """Method to set nfs server"""
        self._nfs_server = value

    @property
    def plan(self):
        """Method to get plan associated with network store"""
        return self._plan

    @plan.setter
    def plan(self, value):
        """Method to set plan to associate with network store"""
        self._plan = value

    def navigate_to_network_store(self):
        """Method to navigate to network stores page"""

        self.__navigator.navigate_to_infrastructure()
        self.__admin_console.access_tile("tileMenuSelection_networkStore")

    def create_network_store(self):
        """Method to create network store"""

        self.navigate_to_network_store()
        self._network_store_obj.add_network_store(self.network_store_name,
                                                  [self.nfs_server],
                                                  [self.plan])

    def remove_network_store(self):
        """Method to delete network store"""

        self.navigate_to_network_store()
        self._network_store_obj.delete_network_store(self.network_store_name)

    def validate_network_store_creation(self):
        """Method to confirm if the network store is created with given details"""

        self.navigate_to_network_store()
        self.__table.apply_filter_over_column("Network store", self.network_store_name)
        network_store_details = self.__table.get_table_data()

        expected_details = {
            "Network store": self.network_store_name,
            "Status": "Ready",
            "Plan": self.plan,
            "NFS server": self.nfs_server
        }

        for key, value in expected_details.items():
            if value == network_store_details[key][0]:
                self.log.info(f"Expected value for {key} matches displayed value")
            else:
                raise Exception(f"Expected value for {key} does not match displayed value")

    def validate_delete(self):
        """Method to verify if network store has been deleted"""

        self.navigate_to_network_store()
        self.__table.apply_filter_over_column("Network store", self.network_store_name)
        if self.__admin_console.check_if_entity_exists("link", self.network_store_name):
            raise Exception(f"Network store {self.network_store_name} not deleted successfully")
        else:
            self.log.info(f"Network store {self.network_store_name} deleted successfully")

