# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""This module provides the function or operations related to Storage in AdminConsole
NASHelper : This class provides methods for NAS related operations

NASHelper
===========

__init__(admin_console obj, csdb obj)  --  initialize object of ArrayHelper class associated


    delete_client()                 --  Deletes NAS Client
    add_server()                    -- Add NAS server from Array Management
    reconfigure_server()            --  Reconfigures the NAS server after adding the server from array management
    delete_array()                  -- Deletes the array from array management
    retire_server()                 --  Retire server after it has been deleted


"""

from AutomationUtils import logger
from Web.AdminConsole.FileServerPages.file_servers import FileServers
from Web.AdminConsole.AdminConsolePages.Arrays import  Arrays , Engine
from NAS.NASUtils.nashelper import NASHelper
from AutomationUtils.database_helper import get_csdb


class Nashelper():
    """ Helper for handling function calls for Array operations from ArrayDetails."""

    def __init__(self, admin_console, csdb=None):

        """Initialize object for ArrayHelper class.

            Args:
               admin_console:  (obj)   --  browser object

               csdb :   (obj)   -- database object

        """

        self.csdb = csdb
        self.log = logger.get_log()
        self.__admin_console = admin_console
        self.__driver = admin_console.driver
        self.__navigator = admin_console.navigator
        self.fs_server_obj =FileServers(self.__admin_console)
        self.engine_obj = Engine(self.__admin_console)
        self.array_obj = Arrays(self.__admin_console)
        self.nhelper_obj = NASHelper()
        self.array_vendor = None
        self.server_name = None
        self.array_user = None
        self.array_password = None
        self.controllers = None
        self.client_name = None
        self.array_control_host = None
        self.control_host = None
        self.csdb = get_csdb()




    def add_engine(self):
        """Creates Storage Array"""

        self.__navigator.navigate_to_arrays()

        # Add Array
        self.engine_obj.add_engine(self.array_vendor,
                                    self.server_name,
                                    self.array_user,
                                    self.array_password,
                                    self.control_host,
                                    self.controllers)


    def reconfigure_server(self):

        """Reconfigures Nas server"""

        self.__navigator.navigate_to_file_servers()
        self.fs_server_obj.reconfigure_server(self.server_name)



    def action_delete_array(self, server_name):

        """Delete Storage Array"""

        # Select Array to delete
        self.__navigator.navigate_to_arrays()
        self.array_obj.action_delete_array(server_name)


    def retire_server(self, server_name):
        """Reconfigures Nas server"""

        self.__navigator.navigate_to_file_servers()
        self.fs_server_obj.retire_server(server_name)


    def delete_client(self, server_name):
        """Delete the client once it is retired"""

        self.__navigator.navigate_to_file_servers()
        self.fs_server_obj.delete_client(server_name)
        self.__admin_console.refresh_page()


    def update_client(self, server_name):
            """
                  This method is to update the NAS server name from ArrayHostAlias table once nas server is added from Array Management
                  Args:
                      server_name: the name of the server

            """

            query = "SELECT NAME FROM APP_Client where ID = (select ClientId from SMControlHost where SMArrayID = '{0}')".format(
                server_name)
            self.csdb.execute(query)
            result = self.csdb.fetch_one_row()
            self.client_name = result[0]
            self.server_name = self.client_name

