# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
File that contains list of constants used by  admin console pages objects and test cases
"""
from enum import Enum


class InternetOptions(Enum):
    """
    Enum with list of all options available under Internet Options in Maintainence tab.
    """
    NO_GATEWAY = "No gateway"
    USE_METRIC_SERVER = "Use Metrics Server"
    USE_CLIENT = "Use client"


class DownloadOptions(Enum):
    """
    Enum with list of all options available under Download software in Maintainence tab.
    """
    LATEST_SP = "servicePack"
    LATEST_HF_FOR_INSTALLED_SP = "hotFixes"
    GIVEN_SP_AND_HF = "servicePackAndHotfixes"


class Packages(Enum):
    """
    Enum with list of packages names in the install/uninstall dropdown
    """
    MEDIA_AGENT = "MediaAgent"
    FILE_SYSTEM_CORE = "File System Core"
    FILE_SYSTEM = "File System"
    ORACLE = "Oracle"
    COMMAND_CENTER = "Command Center"
    CONTENT_EXTRACTOR = "Content Extractor"
    INDEX_GATEWAY = "Index Gateway"
    INDEX_STORE = "Index Store"
    MESSAGE_QUEUE = "Message Queue"
    METRICS_REPORTING = "Metrics Reporting"
    METRICS_REPORTING_DB = "Metrics Reporting DB"
    MONGO_DB = "Mongo DB"
    VIRTUAL_SERVER = "Virtual Server"
    VSS_PROVIDER = "VSS Provider"
    VSS_HARDWARE_PROVIDER = "VSS Hardware Provider"
    WEB_SERVER = "Web Server"


class DownloadOS(Enum):
    """
    List of supported OS groups.
    """
    WINDOWS_32 = "Windows(32)"
    WINDOWS_64 = "Windows(X64)"
    UNIX_AIX = "Aix PPC"
    UNIX_AIX32 = "Aix-PPC-32"
    UNIX_MAC = "macOS"
    UNIX_FREEBSD86 = "Freebsd X86"
    UNIX_FREEBSD64 = "Freebsd X86_64"
    UNIX_HP = "HP IA64"
    UNIX_LINUX86 = "Linux X86"
    UNIX_LINUX64 = "Linux X86_64"
    UNIX_S390 = "Linux-S390"
    UNIX_S390_31 = "Linux-S390-31"
    UNIX_PPC64 = "Linux-PPC-64"
    UNIX_SOLARIS86 = "Solaris X86"
    UNIX_SOLARIS64 = "Solaris X86_64"
    UNIX_SOLARIS_SPARC = "Solaris SPARC"
    UNIX_SOLARIS_SPARC86 = "Solaris-SPARC-X86"


class DownloadOSID(Enum):
    """
    List of supported OS groups.
    """
    WINDOWS_32 = "Windows(32)"
    WINDOWS_64 = "Windows(X64)"
    UNIX_AIX = "AIX PPC"
    UNIX_AIX32 = "Aix-PPC-32"
    UNIX_AIX52_32 = "AIX52-32"
    UNIX_MAC = "macOS"
    UNIX_FREEBSD86 = "Freebsd X86"
    UNIX_FREEBSD64 = "Freebsd X86_64"
    UNIX_HP = "HP IA64"
    UNIX_LINUX86 = "Linux X86"
    UNIX_LINUX64 = "Linux X86_64"
    UNIX_S390 = "Linux-S390"
    UNIX_S390_31 = "Linux-S390-31"
    UNIX_PPC64 = "Linux PPC64"
    UNIX_PPC64le = "Linux PPC64le"
    UNIX_SOLARIS86 = "Solaris X86"
    UNIX_SOLARIS64 = "Solaris X86_64"
    UNIX_SOLARIS_SPARC = "Solaris SPARC"
    UNIX_SOLARIS_SPARC86 = "Solaris-SPARC-X86"
    UNIX_LINUX_ARM64 = "Linux ARM64"


class LocaleFile(Enum):
    """
    List of all pages and its locale file names
    """
    AdminPage = "capps, browse, navJs, messagesJs, messages, vmsJs, collections, settingsJs, actions, users, " \
                + "clients, devices"
    AddDBInstance = "dbs, ediscovery, postgres"
    Agents = "navJs"
    AlertDefinitions = "navJs"
    Alerts = "navJs"
    AlertsDefinitionsInfo = "navJs"
    ArrayDetails = "navJs"
    Arrays = "snapArray"
    Backupset = "ediscovery, postgres, capps"
    PostgreSQLBackupset = "dbs, postgres"
    DB2Backupset = "dbs, db2, Browse"
    Commcell = "sendLogs"
    DBInstance = "navJs"
    DBInstances = "informix, sybase, postgres, dbs, capps, servers"
    Domains = "navJs"
    BackupSets = "navJs"
    Subclients = "navJs"
    GlobalExceptions = "navJs"
    Jobs = "job"
    KeyManagementServers = "navJs"
    Maintenance = "navJs, settings, schedule, users"
    OperationWindow = "navJs"
    PlanDetails = "profiles"
    Plans = "profiles, ediscovery"
    Roles = "navJs"
    ServerDetails = "navJs"
    ServerGroups = "navJs"
    Servers = "navJs, users, settings, servers"
    Laptops = "navJs, devices"
    Settings = "navJs"
    SNMPConfiguration = "navJs"
    SubclientPolicies = "navJs"
    SubclientPolicyDetails = "navJs"
    SubclientPolicySubclientDetails = "navJs"
    StoragePolicies = "navJs"
    StoragePolicyDetails = "navJs"
    DiskStorage = "storage"
    DiskStorageDetails = "storage"
    CloudStorage = "storage"
    CloudStorageDetails = "storage"
    SubclientDetails = "navJs"
    TriggeredAlerts = "navJs"
    Users = "users, usersJs"
    UserDetails = "users, usersJs"
    BackupsetLevel = "navJs"
    ClientDetails = "navJs"
    FileSystem = "navJs"
    FsAgent = "fs"
    FsBackupset = "navJs"
    FsSubclient = "fs"
    FsSubclientDetails = "ServersJS, fs, restore"
    FileServers = "ServersJS, fs, clients, servers , devices, profiles, settings, setup, messages, archiving"
    NASFileServers = "ServersJS, fs, clients, servers , devices, profiles, settings, setup, messages, archiving"
    AddPanel = "ServersJS, fs"
    iDA = "navJs"
    Restores = "navJs"
    RestoreSelectVolume = "navJs"
    Subclient = "navJs"
    NASTemplate = "settings, nas"
    DataSourceDiscover = "ediscovery"
    DataSourceReview = "ediscovery, exchange"
    FileServerLookup = "ediscovery, exchange"
    FileStorageOptimization = "ediscovery"
    ReviewRequest = "ediscovery"
    GovernanceApps = "ediscovery"
    CaseManager = "exchange"
    EntityManager = "ediscovery"
    ClassifierManager = "ediscovery,profiles"
    InventoryManager = "ediscovery"
    InventoryManagerDetails = "ediscovery"
    SensitiveDataAnalysis = "ediscovery"
    SensitiveDataAnalysisProjectDetails = "ediscovery"
    DiskLevelRestore = "navJs"
    FullVMRestore = "navJs, serversJs, messages"
    GuestFilesRestoreSelectFolder = "navJs, restore, userPermissions"
    GuestFilesRestoreSelectVolume = "navJs"
    EndUserGuestFilesRestoreSelectFolder = "navJs, restore"
    EndUserFullVMRestore = "navJs, serversJs"
    HypervisorDetails = "navJs, vmsJs, servers, settings, clients"
    Hypervisors = "navJs, servers"
    ManageContent = "navJs, users"
    Report = "navJs"
    ManageReport = "navJs"
    ReplicationTargetDetails = "navJs, replicationGroups"
    ReplicationTargets = "navJs, replicationGroups"
    ReplicationMonitor = "replicationGroups, dr"
    ContinuousReplicationMonitor = "dr, blrJs, messagesJs"
    RestoreSelectVM = "navJs"
    SelectRestore = "navJs, restore"
    VirtualMachineFilesRestore = "navJs"
    VMGroups = "navJs, dr"
    VMStatus = "navJs"
    VirtualMachines = "vms, vmsJs, dr"
    VMDetails = "vms, vmsJs, dr"
    VsaSearchRestore = "navJs"
    VsaSubclientDetails = "navJs, vmsJs, serversJs, dr"
    Dashboard = "reports"
    Email = "reports"
    ReplicationGroupDetails = "navJs, job"
    ReplicationGroup = "vmsJs, fs"
    ConfigureBLR = "fs"
    _ConfigureCommon = "messages, collectionsJs"
    ReplicaCopy = "fs"
    RecoveryTargets = "navJs"
    _AzureRecoveryTarget = "restore"
    _VMwareVMOptions = "restore"
    RecoveryPointStore = "storage, vmsJs"
    ConfigureVSAReplicationGroup = "navJs"
    ConfigureReplicationGroup = "navJs"
    SQLServerReplication = "navJs"
    SQLInstances = "sqlServerInstance"
    SQLInstance = "sqlServerInstance"
    ManageSchedules = "reports"
    ConfigureSchedules = "reports"
    Tag = "reports"
    IdentityServers = "users"
    IdentityServerDetails = "users"
    Virtualization = "profiles, settings, servers, devices, setup"
    GettingStarted = "setup, messages"
    MediaAgents = "navJs, users"
    CommonFeatures = "reports"
    Table = "reports"
    ManageAlerts = "reports"
    Instances = "bigData"
    CassandraServer = "bigData"
    SplunkServer = "bigData"
    Configuration = "bigData"
    Overview = "bigData"
    Restore = "bigData"
    Archiving = "navJs"
    PermissionReport = "ediscovery"
    RequestManager = "ediscovery"
    DomainDetails = "navJs"
    CredentialManager = "navJs"
    Theme = "navJs"
    ObjectStorage = "cloudStorageApp, cloudStorageAppJs"
    Browse = "restore, browse"
    EmailHeaderFooter = 'navJs'
    EmailTemplates = 'navJs'
    LiveMount = "navJs"
    ReplicationDetails = "replicationGroups"
    OverviewTab = "replicationGroups, vmsJs"
    ConfigurationTab = "profiles, vmsJs, replicationGroups, serversJs, restore"
    EditVirtualMachine = "restore"
    Office365Apps = "office365, exchange"
    Kubernetes = "profiles, settings, servers, devices, setup"
