# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This module provides the function or operations that can be used to run
basic operations on Regions or Region details page.

Class:

    RegionMain()

Functions:

    add_new_region()                :   Method to create a new region

    validate_region_locations()     :   Method to validate the locations shown under a particular region

    modify_region_location()        :   Method to modify the region locations

    delete_created_region()         :   Method to delete the region created in the test case
"""

from Web.AdminConsole.AdminConsolePages.regions import Regions


class RegionMain(object):
    """
        Helper for region/region details page
    """

    def __init__(self, admin_console):
        """
            Initializes the RegionMain helper module

            Args:
                admin_console  (object)   --  Admin Console class object
        """

        self.__admin_console = admin_console
        self.__navigator = admin_console.navigator
        self.__region = Regions(self.__admin_console)
        self.log = admin_console.log

        self.__region_name = 'newRegionTest'
        self.__region_locations = ['Kanpur', 'Lucknow']
        self.__edit_region_locations = ['Chennai']

    @property
    def region_name(self):
        """ Get Region name"""
        return self.__region_name

    @region_name.setter
    def region_name(self, value):
        """ Set Region name"""
        self.__region_name = value

    @property
    def region_locations(self):
        """ Get Region locations"""
        return self.__region_locations

    @region_locations.setter
    def region_locations(self, value):
        """ Set Region locations"""
        self.__region_locations = value

    @property
    def edit_region_locations(self):
        """ Get region edit locations"""
        return self.__edit_region_locations

    @edit_region_locations.setter
    def edit_region_locations(self, value):
        """ Set Region edit locations"""
        self.__edit_region_locations = value

    def add_new_region(self):
        """
        Function to add new region
        """
        self.__navigator.navigate_to_regions()
        self.__region.add_region(self.region_name, self.region_locations)

    def validate_region_locations(self):
        """
        Function to validate the locations under a given region
        """
        self.__navigator.navigate_to_regions()
        location_list = self.__region.get_region_locations(self.region_name)
        location_list = location_list[0]
        for location in self.region_locations:
            if location_list.find(location) == -1:
                exp = 'Error in finding location'+' '+location
                self.log.exception(exp)
                raise Exception(exp)
            self.log.info('Location {} matched successfully'.format(location))

    def modify_region_location(self):
        """
        Function to modify region locations
        """
        self.__navigator.navigate_to_regions()
        self.__region.edit_region_locations(self.region_name, self.edit_region_locations)
        add_locations = self.edit_region_locations['Add']
        remove_locations = self.edit_region_locations['Remove']
        self.region_locations.extend(add_locations)
        for location in remove_locations:
            self.region_locations.remove(location)

    def delete_created_region(self):
        """
        Function to modify region locations
        """
        self.__navigator.navigate_to_regions()
        self.__region.delete_region(self.region_name)
