# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This module provides the function or operations that can be performed
while selecting the restore volume on the AdminConsole

Class:

    RestoreSelectVolume() -> AdminPage() -> LoginPage() -> AdminConsoleBase() -> object()

Functions:

select_volume()          -- select and open a volume

"""

from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.Common.handlers import adminconsole_handler


class RestoreSelectVolume(AdminPage):
    """
    This class provides the function or operations that can be performed
    while selecting the restore volume on the AdminConsole
    """

    @adminconsole_handler()
    def select_volume(self, volume):
        """Opens the volume for further browsing.
            volume   : a string, volume label we want to select
        """
        self.log.info("Selecting the volumes for restore")
        if self.check_if_entity_exists("link", volume):
            self.select_hyperlink(volume)
        else:
            raise Exception("There is no volume with the given name")
