# -*- coding: utf-8 -*-

# ---------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# ----------------------------------------------------------------------------

"""
This module provides the function or operations that can be performed on the Subclient Policy subclient details page in
admin console

Class:
      SubclientPolicySubclientDetails() -> AdminPage() -> login_page() -> AdminConsoleBase() ->object()

Functions :

edit_subclient_name()                   --- Method to edit the subclient name inside a subclient policy

edit_subclient_content()                --- Method to edit the subclient content associated to a subclient policy

"""

from Web.Common.handlers import adminconsole_handler
from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage


class SubclientPolicySubclientDetails(AdminPage):
    """ Class for Subclient Policy subclient details page"""
    @adminconsole_handler()
    def edit_subclient_name(self, subclient_name, new_subclient_name):
        """
        Method to change the subclient policy name

        Args:
         subclient_name (str): subclient name to be changed
         new_subclient_name (str):name of the subclient after modification

        Returns:
            None
        Raises :
             Exception:
              -- if failed to change the subclient  name
        """
        self.log.info("Editing the subclient  name: %s", subclient_name)
        if self.check_if_entity_exists("xpath", "//h1[@id]"):
            name = self.driver.find_element_by_xpath("//h1[@id]")
        else:
            raise Exception("Unable to edit the subclient name")
        name.click()
        name.clear()
        name.send_keys(new_subclient_name)
        self.driver.find_element_by_xpath("//span[contains(@title,'Security')]").click()
        self.wait_for_completion()
        self.log.info("subclient name was edited successfully")
        self.check_error_message()

    @adminconsole_handler()
    def edit_subclient_content(self, subclient_path, new_subclient_path):
        """
        Method to edit the subclient content

        Args:
            subclient_path (str): subclient path before modification
            new_subclient_path (str): subclient path after modification

        Returns:
            None
        Raises :
             Exception:
              -- if failed to change the subclient  name
        """
        self.log.info("Editing the subclient  path: %s", subclient_path)
        self.driver.find_element_by_xpath(
            "//a[@data-ng-click='manageSubclientContent()' and text()='Edit']").click()
        self.select_hyperlink("Content")
        path = self.driver.find_element_by_xpath("//input[@placeholder='Enter custom path']")
        path.clear()
        path.send_keys(new_subclient_path)
        self.wait_for_completion()
        self.driver.find_element_by_xpath("//i[@title='Add'][@data-ng-click='addCustomPath(0)']").click()
        self.wait_for_completion()
        self.click_button("OK")
        self.log.info("Subclient content was edited successfully.")
        self.check_error_message()

    @adminconsole_handler()
    def edit_storage_policy(self, storage_policy_name, new_storage_policy_name):
        """
        Method to change the storage policy name for subclient

         Args:
         storage_policy_name (str): storage policy name to be changed
         new_storage_policy_name (str):name of the storage policy after modification

        Returns:
            None
        Raises :
             Exception:
              -- if failed to change the subclient  name
        """
        self.log.info("Changing the subclient storage policy from %s to %s", storage_policy_name,
                      new_storage_policy_name)
        self.select_configuration_tab()
        self.driver.find_element_by_xpath("//a[@data-ng-click='editPolicies()']").click()
        self.cv_single_select('Storage policy', new_storage_policy_name)
        self.click_button("Save")
        self.log.info("Storage policy for the subclient is modified successfully")
        self.check_error_message()
