# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This module provides the function or operations that can be performed on the
server groups page of the File System iDA on the AdminConsole

Class:

    ServerGroups() -> AdminPage() ->  AdminConsoleBase() -> object()

Functions:

open_server_group()      -- open the server group

"""
from Web.AdminConsole.Components.table import Table
from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.Common.page_object import PageService


class ServerGroups(AdminPage):
    """Class for server groups page of adminconsole """

    def __init__(self, driver):
        super().__init__(driver)
        self.__table = Table(self)

    @PageService()
    def open_server_group(self, group_name):
        """
        Opens a server group with the given name.

        Args:
            group_name (str): the name of the server group to be opened

        Returns:
            None

        Raises:
            Exception:
                The given server is not present
        """
        self.__table.access_link(group_name)
