# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
"""
This module provides the function or operations that can be performed on replication monitor page

"""

from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.AdminConsole.Components.table import Table
from Web.Common.page_object import PageService
from Web.AdminConsole.Components.table import Table


class ReplicationMonitor(AdminPage):
    """All operation on s specific to Replication monitors goes here"""

    def __init__(self, driver):
        super().__init__(driver)
        self.__table = Table(self)

    @PageService()
    def bring_online(self, group_name):
        """Brings the given group online

        Args:
            group_name(str): Group name

        """
        self.__table.access_context_action_item(group_name, "Bring online")
