# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
"""
This module provides the function or operations that can be performed on the
replication page of the AdminConsole

"""


from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.AdminConsole.Components.table import Table
from Web.Common.exceptions import CVWebAutomationException
from Web.Common.page_object import WebAction, PageService
from Web.AdminConsole.Components.table import Table


class ReplicationGroup(AdminPage):
    """Class for Replication Groups Page"""

    def __init__(self, driver):
        super().__init__(driver)
        self.__table = Table(self)

    @WebAction()
    def __click_menu_link(self, menu_id):
        """
        Clicks on menu link
        Args:
            menu_id: Id of menu item

        Returns:

        """
        self.driver.find_element_by_id(menu_id).click()

    @WebAction()
    def __click_delete_link(self):
        """Clicks the Delete link"""
        self.driver.find_element_by_id(self.props['label.globalActions.delete']).click()

    @PageService()
    def configure_sql_server_replication_group(self):
        """Configures a SQL Server replication group"""
        self.access_menu('Configure replication group')
        self.__click_menu_link('ConfigureSQLReplicationGroup')
        self.wait_for_completion()

    @PageService()
    def delete_group(self, group_name):
        """Deletes the given group

        Args:
            group_name  (str):  Name of the group to be deleted

        """

        self.wait_for_completion()
        self.__table.access_action_item(group_name, self.props['label.delete'])
        self.click_button(self.props['button.yes'])
        if self.check_if_entity_exists("link", group_name) is False:
            return
        raise CVWebAutomationException(f"The group {group_name} cannot be deleted")

    @PageService()
    def access_group(self, group_name):
        """Access the given replication group

        Args:
            group_name(str):    Name of the group to be accessed

        """
        self.__table.access_link(group_name)

    @PageService()
    def has_group(self, group_name):
        """Returns True if group exists

        Args:
            group_name(str):    Name of the group

        """
        return self.check_if_entity_exists("link", group_name)

    @PageService()
    def replicate_group(self, group_name):
        """Replicates the given group

        Args:
            group_name(str):    Name of the group to be replicated

        """
        self.__table.access_context_action_item(group_name, "Replicate now")

    @PageService()
    def configure_ls_replication_group(self):
        """Selects configure replication group, virtualization"""
        self.access_menu('Configure replication group')
        self.__click_menu_link('ConfigureVSAReplicationGroup')
        self.wait_for_completion()
