from Web.AdminConsole.Components.table import Table
from Web.AdminConsole.Components.panel import ModalPanel, DropDown


class NetworkStore:
    """Class for network stores page"""

    def __init__(self, admin_console):

        """
        Args:
        admin_console(AdminConsole): adminconsole
        object
        """

        self._admin_console = admin_console
        self._driver = admin_console.driver

        # Components required
        self.__table = Table(self._admin_console)
        self.__panel = ModalPanel(self._admin_console)
        self.__dropdown = DropDown(self._admin_console)

    def add_network_store(self, network_store_name, nfs_server, plan=None):
        """Method to add network store"""

        self._admin_console.select_hyperlink("Add network store")
        self._admin_console.fill_form_by_id("nfsObjectStoreName", network_store_name)
        self.__dropdown.select_drop_down_values(0, nfs_server)

        if plan:
            self.__dropdown.select_drop_down_values(1, plan)

        self._admin_console.click_button("Save")

    def delete_network_store(self, network_store_name):
        """Method to delete a network store"""

        self.__table.access_action_item(network_store_name, "Delete")
        self._admin_console.click_button("Yes")
