# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
This module provides the function or operations related to media agents page

==============

  select_media_agent()        --    selects the given MA

  delete_media_agent()        --    deletes the given MA
"""

from Web.AdminConsole.Components.table import CVTable
from Web.AdminConsole.Components.dialog import ModalDialog
from Web.Common.page_object import PageService


class MediaAgents:
    """
    Class for media agents page in Admin console

    """

    def __init__(self, admin_console):
        """ Initialize the MediaAgents obj

        Args:
            admin_console (AdminConsole): AdminConsole object

        """
        self.__admin_console = admin_console
        self.__driver = admin_console.driver
        self.__admin_console._load_properties(self)
        self.__table = CVTable(self.__admin_console)

    @PageService()
    def access_media_agent(self, media_agent):
        """
        selects the media agent with the given name

        Args:
            media agent    (str)   -- Name of the media agent to be opened
        """
        self.__table.access_link(media_agent)

    @PageService()
    def delete_media_agent(self, media_agent):
        """
        Deletes the media agent with the given name

        Args:
            media_agent (str) - name of the media agent to be deleted
        """
        self.__table.access_action_item(media_agent, self.__admin_console.props['action.delete'])
        diag = ModalDialog(self.__admin_console)
        diag.type_text_and_delete('confirm')
        self.__admin_console.check_error_message()
