# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------
"""
This module provides the function or operations that can be performed on the
configure replication group page of the AdminConsole

"""


from Web.AdminConsole.AdminConsolePages.AdminPage import AdminPage
from Web.Common.page_object import (
    WebAction,
    PageService
)


class ConfigureReplicationGroup(AdminPage):
    """Class for Configuring Replication Group Page"""

    @WebAction()
    def __click_live_sync(self):
        """Selects Live Sync Option"""
        self.driver.find_element_by_xpath("//*[@id='wrapper']/div[2]/div[2]/"
                                          "div/div[2]/div/div/ui-view/div/"
                                          "div[1]/div").click()

    @PageService()
    def select_live_sync(self):
        """Select Live Sync"""
        self.__click_live_sync()
