"""
This module provides the function or operations that can be performed on
the License page on the AdminConsole

Class:

    License() -> AdminConsoleBase() -> object()

Functions:

    get_license_details     :   Returns license page details

    apply_update_license    :   Applies/Updates license of the Commcell

"""

from Web.Common.page_object import WebAction, PageService
from Web.AdminConsole.Components.panel import PanelInfo


class License:
    """ Class for License page of AdminConsole """
    def __init__(self, admin_console):
        self.__admin_console = admin_console
        self.__driver = admin_console.driver
        self.__p_info = None

    @WebAction()
    def __select_license_file(self, file_path):
        """ Selects license file from local controller """
        input_element = self.__driver.find_element_by_xpath("//input[contains(@data-ng-change,'onInputChange()')]")
        input_element.send_keys(file_path)

    @PageService()
    def get_license_details(self):
        """ Returns license page details """
        self.__p_info = PanelInfo(self.__admin_console)
        details = self.__p_info.get_details()
        return details

    @PageService()
    def apply_update_license(self, file_path):
        """ Applies/Updates License on the License page """
        PanelInfo(self.__admin_console, 'License details').edit_tile()
        self.__admin_console.wait_for_completion()
        self.__select_license_file(file_path)
        self.__admin_console.wait_for_completion()
        self.__admin_console.click_button("Apply")
        self.__admin_console.check_error_message()
