"""
Main file  for declaring all constants needed for  VSA Automation
"""

import os
from enum import Enum

APP_TYPE = 106
Ip_regex = "(^169\.)"
AppName = "VIRTUAL SERVER"
AutomationAppType = "Q_VIRTUAL_SERVER"
PseuDoclientPropList = 'Virtual Server Host', 'Virtual Server User'
vm_pattern_names = {'[OS]': 'GuestOS',
                    '[DNS]': 'server_name',
                    '[DS]': 'Datastore',
                    '[VM]': 'vm_name',
                    '[HN]': 'server_clientname',
                    '[Tag]': 'tag',
                    '[TagCategory]': 'tagcategory',
                    '[VMName]': 'vm_name',
                    '[Virtual Machine]': 'vm_name'}

filter_type_mapping = {
    "gcp": {
        "server": "zone",
        "datacenter": "region"
    },

    "azure stack": {
        "datastore": "storage_account",
        "tagcategory": "tag_name",
        "tag": "tag_value",
        "server": "resource_group"
    },

    "hyper-v": {
        "server": ""
    }
}

content_types = {'Virtual Machine': "[VM]", '1': "[HN]", 'Tag': "[Tag]", 'TagCategory': "[TagCategory]"}
disk_count_command = "(get-disk | select number, size).count"

attr_name = ('Virtual Server User', 'Virtual Server Password', 'Amazon Center Access Key',
             'Amazon Center Secret Key', 'Virtual Server Host', 'Azure Subscription Id', 'Azure Tenant Id',
             'Oracle Cloud Infrastructure Tenancy Id', 'Oracle Cloud Infrastructure User Id',
             'Oracle Cloud Infrastructure Finger Print', 'Oracle Cloud Infrastructure Private File Name',
             'Oracle Cloud Infrastructure Private Key Password', 'Oracle Cloud Infrastructure Region Name')

pruning_constants = {"min_percentage_limit": 10, "min_available_limit": 100000}

class hypervisor_type(Enum):
    """
    Enum class for declaring allt he Hypervior types
    """

    VIRTUAL_CENTER = "VMware"
    MS_VIRTUAL_SERVER = "Hyper-V"
    AZURE = "Azure"
    AZURE_V2 = "Azure Resource Manager"
    Fusion_Compute = "FusionCompute"
    ORACLE_VM = "OracleVM"
    Alibaba_Cloud = "Alibaba Cloud"
    Oracle_Cloud_Classic = "Oracle Cloud"
    Google_Cloud = "Google Cloud Platform"
    OPENSTACK = "OpenStack"
    Azure_Stack = "Azure Stack"
    Rhev = "Red Hat Virtualization"
    AMAZON_AWS = "Amazon"
    ORACLE_CLOUD_INFRASTRUCTURE = "ORACLE CLOUD INFRASTRUCTURE"
    Vcloud = "vCloud Director"
    Nutanix = "Nutanix AHV"
    Xen = "Xen"


def on_premise_hypervisor(instance_name):
    """
    :param instance_name:  Instance name of the Instance need to be checked
    :return:
        True if the Hypervisor is on premise else false

    """
    vendor = {'vmware': True, 'hyper-v': True, 'azure resource manager': False, 'Azure': False,
              'fusioncompute': False, 'oraclevm': False, 'red hat virtualization': True,
              'amazon': True, 'openstack': False, 'nutanix ahv': False, 'alibaba cloud': False,
              'oraclecloud': False, 'google cloud platform': False,
              'oracle cloud infrastructure': False, 'vcloud director': True, 'xen': True, 'kubernetes': False}
    return vendor[instance_name]


def azure_cloud_hypervisor(instance_name):
    """
    :param instance_name:  Instance name of the Instance need to be checked
    :return:
        True if the Azure specific Hypervisor else false

    """
    vendor = {'vmware': False, 'hyper-v': False, 'azure resource manager': True,
              'Azure': True, 'fusioncompute': False, 'oraclevm': False, 'azure stack': True,
              'red hat virtualization': False, 'openstack': False, 'alibaba cloud': True,
              'oraclecloud': True, 'amazon': False, 'nutanix ahv': False,
              'google cloud platform' : False, 'oracle cloud infrastructure': False, 'xen': False, 'kubernetes': False}

    return vendor[instance_name]


def instance_helper(instance_name):
    """

    Args:
        instance_name          (str): Name of the instance

    Returns:
                                (str): Helper of the instance
    """
    helper = {
        'vmware': 'VmwareHelper',
        'hyper-v': 'HyperVHelper',
        'azure resource manager': 'AzureHelper',
        'azure stack': 'AzureStackHelper',
        'fusioncompute': 'FusionComputeHelper',
        'oraclevm': 'OracleVMHelper',
        'oracle cloud': 'OracleCloudHelper',
        'google cloud platform': 'GoogleCloudHelper',
        'openstack': 'OpenStackHelper',
        'red hat virtualization': 'RedHatHelper',
        'amazon': 'AmazonHelper',
        'oracle cloud infrastructure': 'OciHelper',
        'vcloud director': 'VcloudHelper',
        'nutanix ahv': 'NutanixHelper',
        'alibaba cloud': 'AliCloudHelper',
        'xen': 'XenHelper',
        'Kubernetes': 'KubernetesHelper'

    }
    return helper.get(instance_name)


def instance_vmhelper(instance_name):
    """

    Args:
        instance_name          (str): Name of the instance

    Returns:
                                (str): VM Helper of the instance
    """
    vm_helper = {
        'vmware': 'VmwareVM',
        'hyper-v': 'HyperVVM',
        'azure resource manager': 'AzureVM',
        'azure stack': 'AzureStackVM',
        'fusioncompute': 'FusionComputeVM',
        'oraclevm': 'OracleVMHelper',
        'oracle cloud': 'OracleCloudVM',
        'google cloud platform': 'GoogleCloudVM',
        'openstack': 'OpenStackVM',
        'red hat virtualization': 'RedHatVM',
        'amazon': 'AmazonVM',
        'oracle cloud infrastructure': 'OciVM',
        'vcloud director': 'VcloudVM',
        'nutanix ahv': 'NutanixVM',
        'alibaba cloud': 'AliCloudVM',
        'xen': 'XenVM'
    }
    return vm_helper.get(instance_name)


def is_dynamic_type(vm_name, vm_type):
    """
    check whether the VM string passed contain dynamic VM

    Args:
            vm_name: name of the VM eg: VM1, VM*
            vm_type  : Type of the Input like VM name, HostName

    Returns:
            Bool value based on dynamic or not
    """

    is_not_dynamic = False
    vm_name_type = ['9', '10']
    if vm_type in vm_name_type:
        if '*' not in vm_name:
            is_not_dynamic = True

    return is_not_dynamic


def is_windows(os_name):
    """
    check for the os in Windows or Unix flavours

    Args:
    os_name - Nmae of the OS

    returns:
            bool value based whether the OS is windows or not
    """
    return bool(os_name == "windows")


def get_live_browse_db_path(base_dir):
    """
    Get the db path for the live browse
    Args:
            base_dir - base directory where the contentstore is installed

    return:


    """

    return os.path.join(base_dir, "PseudoMount", "Persistent", "PseudoMountDB")


def get_live_browse_mount_path(base_dir, GUID, os_name):
    """
    Get the devices mount path for the live browse
    Args:
            base_dir            (str): base directory where the contentstore is installed

            GUID                (str): GUID of the VM browsed

            os_name             (str): OS of the VM

    return:
        devices mount path for the live browse

    """

    if os_name.lower() == "windows":
        return os.path.join(base_dir, "PseudoMount", "Persistent", "PseudoDevices", GUID)

    else:
        return "/opt/FBR/cvblk_mounts"


def get_folder_to_be_compared(folder_name, _driveletter, timestamp):
    """
    return the default folder restore path
    Args:
            FolderName - name of the folder
            _driveletter- drive letter where data was copied
            timestamp - timestamp used durnig copying data

    """

    if _driveletter is None:
        return "C:\\TestData\\{0}\\".format(folder_name)
    else:
        return os.path.join(_driveletter, "\\" + folder_name, "TestData", timestamp)


def BrowseFilters():
    """
    :return: Browse Filters for XML
    """
    return r"""&lt;?xml version='1.0' encoding='UTF-8'?&gt;&lt;databrowse_Query type="0"
    queryId="0"&gt;&lt;dataParam&gt;&lt;sortParam ascending="1"&gt;&lt;sortBy val="38"
    /&gt;&lt;sortBy val="0" /&gt;&lt;/sortParam&gt;&lt;paging firstNode="0" pageSize="100"
    skipNode="0" /&gt;&lt;/dataParam&gt;&lt;/databrowse_Query&gt;"""


class ServiceIds(Enum):
    """
    Using enum class create enumerations
    """
    Restart = 1
    Start = 2
    Stop = 3
    Suspend = 4


class ServiceOperationEntity(Enum):
    """
    Using enum class create enumerations
    """
    Co_ordinator = 1
    Worker = 2
    MA = 3
    Other = 4
