# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""
file for Password Generator exe

Method:
encode_password - encodes the password passed from the user and then set that in config file
"""

import getpass
import json
import os
import sys
import ast
from VirtualServer.VSAUtils import VirtualServerUtils
from AutomationUtils import config


def encode_password(vm_user_name, vm_password, vm_os_name):

    if getattr(sys, 'frozen', False):
        application_path = os.path.dirname(sys.executable)
    elif __file__:
        application_path = os.path.dirname(__file__)

    automation_directory = os.path.abspath(
        application_path).split("\\Automation")[0]
    config_file = os.path.join(
        automation_directory, "Automation", "CoreUtils", "Templates", "config.json"
    )
    ini_config = config.get_config(reset=True, json_path=config_file)
    for each_os in vm_os_name:
        section = eval(
            'ini_config.Virtualization.%s.creds' %
            each_os.lower())
        encode_pass = VirtualServerUtils.encode_password(vm_password)
        temp_section = section + "," + "%s:%s" % (vm_user_name, encode_pass)
        with open(config_file, 'r') as json_file:
            json_data = json.load(json_file)
        json_data['Virtualization'][each_os]['creds'] = temp_section

        with open(config_file, 'w') as json_file1:
            json.dump(json_data, json_file1, indent=2, sort_keys=True)

        json_file1.close()

        print("Username:{0}, password:{1}, is written to file {2}".format(
            vm_user_name, encode_pass, config_file
        ))


if __name__ == "__main__":
    user_name = input("Enter Backup VM Username:")
    password = getpass.getpass("Password for " + user_name + ":")
    vm_os = input("Enter Backup VM OS Type:")

    if "windows" in vm_os.lower():
        os_name = ["windows"]
    else:
        os_name = ["unix", "linux"]

    encode_password(user_name, password, os_name)
