#Purpose:  TO Get all VMs and perform operations on ec2


Function Main()
{
$WarningPreference = "SilentlyContinue"
$protocol = "https"

#initialize general variables

$env:Path += ";C:\Program Files\Amazon\AWSCLI"
$global:access_key = "##Automation--access_key--##"   
$global:secret_key = "##Automation--secret_key--##"  
$global:region = "##Automation--region--##"   
$global:vm_name = "##Automation--vm_name--##"    
$global:property= "##Automation--property--##"
[string]$global:extra_args = "##Automation--extra_args--##"

#Set-AWSCredentials -access_key $global:access_key -secret_key $global:secret_key -StoreAs default
#Set-DefaultAWSregion -region $global:region
#Initialize-AWSDefaults -ProfileName default -region $global:region
$env:AWS_ACCESS_KEY_ID = $global:access_key
$env:AWS_SECRET_ACCESS_KEY = $global:secret_key
$env:AWS_DEFAULT_REGION = $global:region
set_region


if($global:property -eq "All")
{
    $var1 = guid
    $var2 = power_state
    $var3 = guest_os
    $var4 = ip
    $var5 = volumes
    $var6 = vpc
    $var7 = subnet
    $var8 = nic
    $var9 = security_group_ids
    $var10 = instance_type
    $var11 = iam
    $var12 = cpu_num
    $var13 = instance_tags_list
    $var14 = volume_tags_list

    #$varxxx = tags


    write-host "guid="$var1";power_state="$var2";guest_os="$var3";ip="$var4";volumes="$var5";vpc="$var6";subnet="$var7";nic="$var8";security_group_ids="$var9";ec2_instance_type="$var10";iam="$var11";no_of_cpu="$var12";instance_tag_list="$var13";volume_tag_list="$var14


}
elseif($global:property -eq "Basic")
{
    $var1 = guid
    $var2 = power_state
    $var3 = guest_os
    $var4 = ip

    write-host "guid="$var1";power_state="$var2";guest_os="$var3";ip="$var4
}
else
{
    $var1 = &$global:property
    write-host $global:property "=" $var1
}
}

Function set_region()
{

$regions = aws ec2 describe-regions --query "Regions[*].[RegionName]" --output text
foreach ($region in $regions){
    $out = aws ec2 describe-instances --region $region --output json
    $str_out = $out | Out-String | ConvertFrom-Json
    $val = $str_out.Reservations.Instances.Tags | where Key -eq 'Name' | where Value -eq $global:vm_name
    if ($val){
        $env:AWS_DEFAULT_REGION = $region
        break
    }

}}

Function guid()
{
    $vm_iid = aws ec2 describe-instances --filters "Name=tag:Name,Values=$global:vm_name" --output text --query 'Reservations[*].Instances[*].InstanceId'
    $ids = $vm_iid.split(" ")
    $count = 0
    $guid
    
    if($ids.Length -gt 1){
        foreach($id in $ids){
            $state =  aws ec2 describe-instances --instance-ids $id --output text --query 'Reservations[*].Instances[*].State.Code'
            if($state -eq '16'){
                $count++
                $guid = $id
            }

        }
    }
    else{
        return $vm_iid
    }
    if($count -gt 1){
        throw "Multiple instances running with the same name. Please make sure multiple ec2 instances do not have the same name tag."
    }
    return $guid  
}

Function power_state()
{
    $vm_iid = guid
    $power_state = aws ec2 describe-instances --instance-ids $vm_iid --output text --query 'Reservations[*].Instances[*].State.Code'
    return $power_state
}

Function guest_os()
{
    $vm_iid = guid
    $guest_os = aws ec2 describe-instances --instance-ids $vm_iid --output text --query 'Reservations[*].Instances[*].Platform'
    if($guest_os -like '*Win*'){
        return "Windows"
    }
    else{
        return "Linux"    # check unix vs linux
    }
}

Function ip()
{
    $vm_iid = guid
    $ip = aws ec2 describe-instances --instance-ids $vm_iid --output text --query 'Reservations[*].Instances[*].PrivateIpAddress'
    return $ip
}

Function volumes()
{
    $vm_iid = guid
    $volumes = aws ec2 describe-volumes --filters "Name=attachment.instance-id,Values=$vm_iid" "Name=status,Values=in-use" --output text --query 'Volumes[*].VolumeId'
    $volume_list = New-Object System.Collections.Generic.List[string]
    $volumes = $volumes.split()
    foreach ($volume in $volumes){
        $volume_list.Add($volume+",")
    }
    return $volume_list
}

Function vpc()
{
    $vm_iid = guid
    $vpc = aws ec2 describe-instances --instance-ids $vm_iid --output text --query 'Reservations[*].Instances[*].VpcId'
    return $vpc
}

Function subnet()
{
    $vm_iid = guid
    $subnet = aws ec2 describe-instances --instance-ids $vm_iid --output text --query 'Reservations[*].Instances[*].SubnetId'
    return $subnet
}

Function nic()
{
    $vm_iid = guid
    $nic = aws ec2 describe-network-interfaces --filters "Name=attachment.instance-id,Values=$vm_iid" --output text --query 'NetworkInterfaces[*].NetworkInterfaceId'
    return $nic
}

Function security_group_ids()
{
    $vm_iid = guid
    $sec_groups = aws ec2 describe-instances --filters "Name=instance-id,Values=$vm_iid" --output text --query 'Reservations[*].Instances[*].SecurityGroups[*].GroupId'
    $security_group_ids = New-Object System.Collections.Generic.List[string]
    foreach($group in $sec_groups){
        $security_group_ids.Add($group+",")
    }
    return $security_group_ids
}

Function instance_type()
{
    $vm_iid = guid
    $instance_type = aws ec2 describe-instances --filters "Name=instance-id,Values=$vm_iid" --output text --query 'Reservations[*].Instances[*].InstanceType'
    return $instance_type
}

Function tags()
{
    $vm_iid = guid
    #aws ec2 describe-tags --filters "Name=resource-id,Values=i-038c68560ccde965f"
    $tags = aws ec2 describe-tags --filters "Name=resource-id,Values=$vm_iid" --output json --query 'Tags[*].[Key, Value]'
    return $tags
}

Function iam()
{
    $vm_iid = guid
    $iam = aws ec2 describe-instances --filters "Name=instance-id,Values=$vm_iid" --output text --query 'Reservations[*].Instances[*].IamInstanceProfile.Id'
    return $iam
}

Function cpu_num()
{
    $vm_iid = guid
    $cpu_num = aws ec2 describe-instances --filters "Name=instance-id,Values=$vm_iid" --output text --query 'Reservations[*].Instances[*].CpuOptions.CoreCount'
    return $cpu_num
}

Function instance_tags_list()
{
    $vm_iid = guid
    $instance_tags_list = New-Object System.Collections.Generic.List[string]
    $keys =  aws ec2 describe-tags --filters "Name=resource-id,Values=$vm_iid" --output text --query 'Tags[*].[Key]'
    Foreach($key in $keys){
        if (-not ([string]::IsNullOrEmpty($key))){
            $value = aws ec2 describe-tags --filters "Name=resource-id,Values=$vm_iid" "Name=key,Values=$key" --output text --query 'Tags[*].Value'
            $instance_tags_list.Add($key+"`t"+$value+"`n")
        }
    }
    return $instance_tags_list
}

Function volume_tags_list()
{
    $vol_id_list = volumes
    $vol_id_list = $vol_id_list.split(",")
    $vm_iid = guid
    $volume_tags_list = New-Object System.Collections.Generic.List[string]
    Foreach($vol_id in $vol_id_list){
        if (-not ([string]::IsNullOrEmpty($vol_id))){
            $vol_id = $vol_id.Trim()
            $volume_tags_list.Add($vol_id+"`t`t")
            $keys =  aws ec2 describe-tags --filters "Name=resource-id,Values=$vol_id" --output text --query 'Tags[*].[Key]'
            Foreach($key in $keys){
                if (-not ([string]::IsNullOrEmpty($key))){
                    $value = aws ec2 describe-tags --filters "Name=resource-id,Values=$vol_id" "Name=key,Values=$key" --output text --query 'Tags[*].Value'
                    $volume_tags_list.Add($key+"`t"+$value+"`n")
                }
            }
            $volume_tags_list.Add("`n`n")
        }
    }
    return $volume_tags_list
}

Function get_all_vms()
{
    $all_vms = aws ec2 describe-instances --region $global:region --output text --query 'Reservations[*].Instances[*].Tags[?Key==`Name`].Value'
    $list_of_vms = New-Object System.Collections.Generic.List[string]
    Foreach($each_vm in $all_vms){
        $list_of_vms.Add($each_vm+",")
    }
    return $list_of_vms
}

