﻿#Purpose:  TO Get properties of the vm from ec2

Function Main()
{
$WarningPreference = "SilentlyContinue"
$protocol = "https"

#initialize general varaibles
$env:Path += ";C:\Program Files\Amazon\AWSCLI"
$global:access_key = "##Automation--access_key--##"  
$global:secret_key = "##Automation--secret_key--##"  
$global:region = "##Automation--region--##"   
$global:vm_name = "##Automation--vm_name--##"   
$global:vm_iid = "##Automation--vm_iid--##" 
$global:vm_user = "##Automation--vm_user--##"
$global:vm_pass = "##Automation--vm_pass--##"
$global:property= "##Automation--property--##"
[string]$global:extra_args = "##Automation--extra_args--##"

$env:AWS_ACCESS_KEY_ID = $global:access_key
$env:AWS_SECRET_ACCESS_KEY = $global:secret_key
$env:AWS_DEFAULT_REGION = $global:region

$var = &$global:property 
write-host $global:property"="$var
}


Function power_on()
{
    try
    {
        $start_instance = aws ec2 start-instances --instance-ids $global:vm_iid --output text --query 'StartingInstances[*].CurrentState.Code'
        return $start_instance 
    }
    catch
    {
        return $false
    }
}


Function power_off()
{
    try
    {
        $stop_instance = aws ec2 stop-instances --instance-ids $global:vm_iid --output text --query 'StoppingInstances[*].CurrentState.Code'
        return $stop_instance
    }
    catch
    {
        return $false
    }
}

Function delete()
{
    try
    {
        $terminate_instance = aws ec2 terminate-instances --instance-ids $global:vm_iid --output text --query 'StoppingInstances[*].CurrentState.Code'
        return $terminate_instance
    }
    catch
    {
        return $false
    }
}

