# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

import random
from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import VsaTestCaseUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of VSA backup and Restore with IP customization"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = 'VSA VMWARE Full Backup and IP customization and Hostname verification on Windows VM'
        self.tc_utils = VsaTestCaseUtils.VSATestCaseUtils(self,
                                                          self.products_list.VIRTUALIZATIONVMWARE,
                                                          self.features_list.DATAPROTECTION,
                                                          tcinputs={
                                                              "source_ip": None,
                                                              "destination_ip": None,
                                                              "dest_computer_name": None
                                                          })
        self.ind_status = True
        self.failure_msg = ''

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = self.tc_utils.initialize(self)
            self.log.info("--__Validating that Proxy and backup vm are windows__--")
            auto_subclient.validate_inputs('windows', '', 'windows', True)
            backup_options = self.tc_utils.run_backup(self, msg='Streaming Full Backup')
            vm_restore_options = self.tc_utils.run_virtual_machine_restore(self,
                                                                           power_on_after_restore=True,
                                                                           unconditional_overwrite=True,
                                                                           source_subnet=self.tcinputs.get(
                                                                               'source_subnet',
                                                                               None),
                                                                           destination_subnet=self.tcinputs.get(
                                                                               'destination_subnet',
                                                                               None),
                                                                           source_gateway=self.tcinputs.get(
                                                                               'source_gateway',
                                                                               None),
                                                                           destination_gateway=self.tcinputs.get(
                                                                               'destination_gateway',
                                                                               None)
                                                                           )
            self.log.info("Validating IP and hostname are properly set")
            for vm in auto_subclient.hvobj.VMs:
                vm = 'del'+vm
                auto_subclient.validate_ip_hostname(vm, ip=self.tcinputs['destination_ip'],
                                                    host_name=self.tcinputs['dest_computer_name'])
        except Exception:
            pass

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options)
                auto_subclient.post_restore_clean_up(vm_restore_options)
            except Exception:
                self.log.warning("Testcase and/or Restored vm cleanup was not completed")
            if not self.ind_status:
                self.result_string = self.failure_msg
                self.status = constants.FAILED
