from AutomationUtils.cvtestcase import CVTestCase
from Reports.Custom.utils import CustomReportUtils
from Web.Common.cvbrowser import (
    Browser, BrowserFactory
)
from Web.Common.exceptions import (
    CVTestCaseInitFailure
)
from Web.Common.page_object import TestStep
from Web.WebConsole.Reports.Custom import builder
from Web.WebConsole.Reports.navigator import Navigator
from Web.WebConsole.webconsole import WebConsole
from Web.WebConsole.Reports.Custom import viewer
from Web.WebConsole.Reports.Custom.builder import Datasets
from Web.WebConsole.Reports.Custom.viewer import PieChart
from Web.Common.page_object import handle_testcase_exception, CVTestStepFailure
from collections import Counter
import re


class TestCase(CVTestCase):
    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Custom Report: Validate Table to Chart Functionality"
        self.utils = CustomReportUtils(self)
        self.webconsole: WebConsole = None
        self.admin_console = None
        self.browser: Browser = None
        self.rpt_builder = None
        self.navigator = None
        self.obj_manage_report = None
        self.dataset = None
        self.data_table = None
        self.table = None
        self.viewer = None
        self.api = None
        self.expected_data = None
        self.report_name = 'TC 59036-Chart to table'
        self.q1 = f"""
                select top 5 status,jobid from jmjobstats
                """

    def init_tc(self):
        try:
            self.utils.cre_api.delete_custom_report_by_name(
                self.report_name, suppress=True
            )
            self.browser = BrowserFactory().create_browser_object()
            self.browser.set_downloads_dir(self.utils.get_temp_dir())
            self.browser.open()
            self.webconsole = WebConsole(
                self.browser, self.commcell.webconsole_hostname
            )
            self.webconsole.login(self.inputJSONnode['commcell']['commcellUsername'],
                                  self.inputJSONnode['commcell']['commcellPassword'])

            Navigator(self.webconsole).goto_report_builder()
            self.rpt_builder = builder.ReportBuilder(self.webconsole)
            self.rpt_builder.set_report_name(self.report_name)
            self.viewer = viewer.CustomReportViewer(self.webconsole)
        except Exception as e:
            raise CVTestCaseInitFailure(e) from e

    @test_step
    def create_dataset(self):
        """Create Database dataset"""
        self.dataset = Datasets.DatabaseDataset()
        self.rpt_builder.add_dataset(self.dataset)
        self.dataset.set_dataset_name("dbdataset")
        self.dataset.set_sql_query(self.q1)
        data = self.dataset.get_preview_data()
        self.expected_data = dict(Counter(list(data.values())[0]))
        self.dataset.save()

    @test_step
    def add_datasource_to_table(self):
        """Add the datasource to any table"""
        self.data_table = builder.DataTable("TestTable")
        self.rpt_builder.add_component(self.data_table, self.dataset)
        self.data_table.add_column_from_dataset()
        self.rpt_builder.save_and_deploy()
        self.rpt_builder.open_report()

    @test_step
    def table_to_chart(self):
        """Converts Table to Chart"""
        self.table = viewer.DataTable("TestTable")
        self.viewer.associate_component(self.table)
        self.table.charts()

    @test_step
    def verify_data(self):
        """Verify that the table data is correct"""
        chart = PieChart("TestTable")
        self.viewer.associate_component(chart)
        _, received_data = chart.get_chart_legend()
        pat = []
        for key in self.expected_data.keys():
            pat.append(str(key) + ': ' + str(self.expected_data[key]))
        for i in range(len(pat)):
            match = re.search(pat[i], str(received_data))
            if not match:
                raise CVTestStepFailure(f"expected legends {pat} "
                                        f"received legends {received_data}")


    def run(self):
        try:
            self.init_tc()
            self.create_dataset()
            self.add_datasource_to_table()
            self.table_to_chart()
            self.verify_data()
        except Exception as err:
            handle_testcase_exception(self, err)
        finally:
            WebConsole.logout_silently(self.webconsole)
            Browser.close_silently(self.browser)
