# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright  Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()          --  initialize TestCase class

    setup()             --  setup function of this test case

    run()               --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from Server.serverhelper import ServerTestCases
from Server.DisasterRecovery.drmanagement_helper import DRManagementHelper
from AutomationUtils.options_selector import OptionsSelector


class TestCase(CVTestCase):
    """Class for executing DR backup test case"""

    def __init__(self):
        """Initializes TestCase object"""
        super(TestCase, self).__init__()
        self.name = "[Negative Case] : Enable DR backup to UNC path"
        self.product = self.products_list.COMMSERVER
        self.feature = self.features_list.DISASTERRECOVERY
        self.show_to_user = True
        self.tc = None
        self.tcinputs = {
            "UncPath": None,
            "UncUser": None,
            "UncPassword": None
        }

    def setup(self):
        """Initializes pre-requisites for test case"""
        self.tc = ServerTestCases(self)

    def validate(self, path, username, password, error_msg):
        """Method to validate the error response received"""
        dr_manager = DRManagementHelper(self.commcell)
        try:
            dr_manager.set_network_dr_path(path, username, password, validate=False)
            raise Exception('Path was set successfully, should have failed,'
                            ' Validation failed')
        except Exception as excp:
            if error_msg not in str(excp):
                raise Exception(str(excp))
            self.log.info('Error as expected : {0}'.format(str(excp)))
            self.log.info('Validation successful')

    def run(self):
        """Execution method for this test case"""
        try:
            custom_string = OptionsSelector(self.commcell).get_custom_str()
            error_msg = 'Failed to set [Backup Metadata Folder] for' \
                        ' [DR Backup] with error [Create directory failed.]'
            path = self.tcinputs["UncPath"]
            password = self.tcinputs["UncPassword"]
            username = self.tcinputs["UncUser"] + '_' + custom_string
            self.log.info('Setting DR backup UNC path with incorrect user name [%s]', username)
            self.validate(path, username, password, error_msg)
            username = self.tcinputs["UncUser"]
            password = self.tcinputs["UncPassword"] + '_' + custom_string
            self.log.info('Setting DR backup UNC path with incorrect password [%s]', password)
            self.validate(path, username, password, error_msg)
            password = self.tcinputs["UncPassword"]
            path = self.tcinputs["UncPath"] + '_' + custom_string
            self.log.info('Setting DR backup UNC path with path unavailable [%s]', path)
            self.validate(path, username, password, error_msg)
            path = self.tcinputs["UncPath"]
            self.log.info('Setting DR backup UNC path with path having data [%s]', path)
            error_msg = 'Failed to save Disaster Recovery Destination in CommServe database' \
                        ' because folder [{0}] is already being used for Disaster Recovery'.format(path)
            self.validate(path, username, password, error_msg)

        except Exception as exp:
            self.tc.fail(exp)
