# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Test case to verify replicate now option in monitor page

Sample input:
"58768": {
            "ClientName": "idcvc61",
            "source" : "backup1",
            "replication_group" : "Auto_test_7575"
       }

"""
from time import sleep
from Server.Scheduler.schedulerhelper import SchedulerHelper
from Web.AdminConsole.DR.replication import ReplicationGroup
from Web.AdminConsole.DR.monitor import ReplicationMonitor
from Web.AdminConsole.adminconsole import AdminConsole
from Web.Common.cvbrowser import BrowserFactory
from Web.Common.cvbrowser import Browser
from Web.Common.exceptions import CVTestCaseInitFailure, CVTestStepFailure
from Web.Common.page_object import TestStep
from AutomationUtils.cvtestcase import CVTestCase
from Reports.utils import TestCaseUtils


class TestCase(CVTestCase):
    """Test case to verify replicate now option"""
    test_step = TestStep()

    def setup(self):
        """Initialize required veriables/inputs"""
        client = self.tcinputs["ClientName"]
        self.source_name = self.tcinputs["source"]
        self.replication_group_name = self.tcinputs["replication_group"]

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Verify replicate now option"
        self.source_name = None
        self.replication_group_name = None
        self.browser = None
        self.utils = None
        self.admin_console = None
        self.navigator = None
        self.replication_monitor = None
        self.schedule_name = None
        self.last_job_id = None
        self.subclient = None
        self.replication_groups = None
        self.utils = TestCaseUtils(self)

    def init_commandcenter(self):
        """Initialize browser and redirect to page"""
        try:
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login()
            self.navigator = self.admin_console.navigator
            self.navigator.navigate_to_replication_monitor()
            self.replication_monitor = ReplicationMonitor(self.admin_console)
            self.replication_groups = ReplicationGroup(self.admin_console)
            self.last_job_id = self.get_last_replication_job_id()
        except Exception as _exception:
            raise CVTestCaseInitFailure(_exception) from _exception

    @test_step
    def trigger_replicate_now(self):
        """Trigger replicate now"""
        self.replication_monitor.replicate_now(self.source_name, self.replication_group_name)
        self.log.info("Triggered replicate now for [%s] replication group and [%s] source" % (
            self.source_name, self.replication_group_name))

    def get_last_replication_job_id(self):
        """Get latest replication job id"""
        self.schedule_name = self.replication_groups.get_schedule_name_by_replication_group(
            self.replication_group_name)
        schedule_obj = self.client.schedules.get(self.schedule_name)
        schedule_helper = SchedulerHelper(schedule_obj, self.commcell)
        job_obj = schedule_helper.get_jobid_from_taskid()
        self.log.info("Found latest job:%s" % job_obj)
        return job_obj.job_id

    @test_step
    def verify_replication_job_triggered(self):
        """wait for replication job to trigger"""
        job_id = self.get_last_replication_job_id()
        if job_id > self.last_job_id:
            self.log.info("Replicate now job is triggered [%s]" % job_id)
        else:
            raise CVTestStepFailure("replicate now job is not triggered")

    @test_step
    def mark_for_full_replication(self):
        """mark for full replication"""
        self.replication_monitor.mark_for_full_replication(self.source_name,
                                                           self.replication_group_name)
        sleep(30)
        self.admin_console.refresh_page()

    def run(self):
        """Starting test case steps"""
        try:
            self.init_commandcenter()
            self.mark_for_full_replication()
            sleep(10)
            self.trigger_replicate_now()
            self.verify_replication_job_triggered()
        except Exception as err:
            self.utils.handle_testcase_exception(err)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
