# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    run()           --  run function of this test case
"""

from AutomationUtils.cvtestcase import CVTestCase
from VirtualServer.VSAUtils import OptionsHelper, VirtualServerUtils
from AutomationUtils import constants


class TestCase(CVTestCase):
    """Class for executing Basic acceptance Test of VSA  backup
        and Restore test case - v2 Indexing"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "VMW-V2 Full Backup without Metadata and File Restores-Special VM"
        self.product = self.products_list.VIRTUALIZATIONVMWARE
        self.feature = self.features_list.DATAPROTECTION
        self.test_individual_status = True
        self.test_individual_failure_message = ""
        self.show_to_user = True
        self.tcinputs = {}

    def run(self):
        """Main function for test case execution"""

        try:
            auto_subclient = VirtualServerUtils.subclient_initialize(self)

            auto_subclient.set_registry_key_for_pruning(self.tcinputs['browse_ma'])

            VirtualServerUtils.decorative_log("Checking Source VM/VMs")
            auto_subclient.validate_inputs("", "", "Windows")
            special_vm_drive = auto_subclient.validate_special_vm()

            VirtualServerUtils.decorative_log("Backup")
            backup_options = OptionsHelper.BackupOptions(auto_subclient)
            if backup_options.collect_metadata:
                raise Exception("MetaData Collection is Enabled")
            auto_subclient.backup(backup_options, special_vm_drive=special_vm_drive)

            try:
                VirtualServerUtils.decorative_log("Guest Files Restore - V2 Indexing")
                file_restore_option = OptionsHelper.FileLevelRestoreOptions(auto_subclient)
                VirtualServerUtils.set_inputs(self.tcinputs, file_restore_option)
                for vm_name in auto_subclient.vm_list:
                    auto_subclient.guest_file_restore(
                        file_restore_option, special_vm_drive=special_vm_drive,
                        discovered_client=vm_name)
            except Exception as exp:
                self.test_individual_status = False
                self.test_individual_failure_message = str(exp)

        except Exception as exp:
            self.log.error('Failed with error: {0}'.format(exp))
            self.result_string = str(exp)
            self.status = constants.FAILED

        finally:
            try:
                auto_subclient.cleanup_testdata(backup_options, {'special_vm_drive': special_vm_drive})
                auto_subclient.del_registry_key_for_pruning(self.tcinputs['browse_ma'])
            except Exception as exp:
                self.log.warning("Cleanup Failed due to error: {0}".format(exp))
            if not self.test_individual_status:
                self.result_string = self.test_individual_failure_message
                self.status = constants.FAILED
