# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

Inputs:
    InstallPath - no_space_drive

"""
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import config, constants
from Install import installer_messages
from Install.install_helper import InstallHelper


class TestCase(CVTestCase):
    """Negative Testcase : Push software to a client with not enough disk space"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Push software to a client with not enough disk space"
        self.config_json = None
        self.windows_machine = None
        self.windows_install_helper = None

    def setup(self):
        """Initializes pre-requisites for this test case"""
        self.config_json = config.get_config()
        install_helper = InstallHelper(self.commcell)
        self.windows_machine = install_helper.get_machine_objects(type_of_machines=1)[0]
        self.windows_install_helper = InstallHelper(self.commcell, self.windows_machine)

    def run(self):
        """Main function for test case execution"""
        try:
            self.log.info("Starting Installation on Windows client")
            path = self.config_json.Install.windows_client.no_space_drive.split(":")[0]
            available_drive_space = self.windows_machine.get_storage_details()[path]['available']
            extra_files_path = path + ":\\Temp"
            if available_drive_space > 100:
                # Filling up the drive with random files to make the drive to have less disk space
                file_size = (available_drive_space * 1000 / 50) - 1000
                flag = self.windows_machine.generate_test_data(file_path=extra_files_path,
                                                               file_size=int(file_size),
                                                               dirs=5,
                                                               files=10)

                if not flag:
                    raise Exception("Failed to fill up space")

            job_install = self.windows_install_helper.install_software(
                client_computers=[self.windows_install_helper.client_host],
                features=['FILE_SYSTEM', 'MEDIA_AGENT', 'TEST_AUTOMATION', 'PYTHON_SDK'],
                install_path=self.config_json.Install.windows_client.no_space_drive
            )
            if job_install.wait_for_completion(10):
                if self.windows_machine.check_directory_exists(extra_files_path):
                    self.windows_machine.remove_directory(extra_files_path)
                self.log.error("Installation Successful! Please provide a low space directory")
                raise Exception("Client installation Successful even with Not enough disk space")

            if self.windows_machine.check_directory_exists(extra_files_path):
                self.windows_machine.remove_directory(extra_files_path)
                
            job_status = job_install.delay_reason
            if installer_messages.QINSTALL_LOW_DISK_SPACE not in job_status:
                self.log.error("Job Failed due to some other reason than the expected one.")
                raise Exception(job_status)

            self.log.info("JobFailingReason:%s", job_status)

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED        