# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

"""
from base64 import b64encode
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import config, constants
from Install import installer_messages
from Install.install_helper import InstallHelper
from Install.install_validator import InstallValidator


class TestCase(CVTestCase):
    """Negative Testcase : Repair software when the machine is not reachable."""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Repair software when the machine is not reachable."
        self.config_json = None

    def setup(self):
        """Initializes test case class object"""
        self.config_json = config.get_config()

    def run(self):
        """Main function for test case execution"""
        try:
            windows_client = self.commcell.clients.get(self.config_json.Install.windows_client.machine_host)
            unix_client = self.commcell.clients.get(self.config_json.Install.unix_client.machine_host)
            cs_clients = [windows_client, unix_client]
            for client_machine in cs_clients:
                if client_machine.is_ready:
                    client_machine.stop_service("GxCVD(Instance001)")

                job = client_machine.repair_software(reboot_client=True)
                if job.wait_for_completion(10):
                    raise Exception("Failed to make the client unreachable")

                job_status = job.delay_reason
                if not (installer_messages.QINSTALL_REPAIR_FAILED_CLIENT_NOT_REACHABLE in job_status):
                    self.log.error("Job Failed due to some other reason than the expected one.")
                    raise Exception(job_status)

                self.log.info("JobFailingReason:%s", job_status)
                install_helper = InstallHelper(self.commcell, client_machine)
                creds = install_helper.get_machine_creds
                job = client_machine.repair_software(
                    username=creds[0],
                    password=b64encode(creds[1].encode()).decode(),
                    reboot_client=True
                )
                if not job.wait_for_completion():
                    job_status = job.delay_reason
                    self.log.error("Repair Job Failed even with credentials given")
                    raise Exception(job_status)

                if client_machine.is_ready:
                    install_validation = InstallValidator(client_machine.client_hostname, self)
                    install_validation.validate_baseline()
                    install_validation.validate_services()
                    install_validation.validate_sp_version()
                    self.log.info("Successfully repaired the client")
                else:
                    raise Exception("Client services are down; Repair Unsuccessful")

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED