# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

"""
from cvpysdk.deployment.deploymentconstants import DownloadPackages
from cvpysdk.deployment.deploymentconstants import DownloadOptions
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from AutomationUtils.machine import Machine
from Install import installer_constants, installer_messages
from Install.install_helper import InstallHelper


class TestCase(CVTestCase):
    """Negative Testcase : Push software when the cache doesn't have specific OS of the client."""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Push software when the cache doesn't have specific OS of the client."
        self.cs_machine = None
        self.sw_cache_helper = None
        self.machine_objects = None

    def setup(self):
        """Initializes test case class object"""
        self.cs_machine = Machine(machine_name=self.commcell.commserv_hostname,
                                  commcell_object=self.commcell)
        install_helper = InstallHelper(self.commcell)
        self.machine_objects = install_helper.get_machine_objects()
        self.sw_cache_helper = self.commcell.commserv_cache

    def run(self):
        """Main function for test case execution"""
        try:
            download_job = self.commcell.download_software(
                options=DownloadOptions.LATEST_HOTFIXES.value,
                os_list=[DownloadPackages.WINDOWS_64.value, DownloadPackages.UNIX_LINUX64.value])
            if download_job.wait_for_completion(10):
                self.log.info("WindowsX64 and Linux64 Packages Downloaded successfully")

            # Restricting download from the job.
            flag = self.cs_machine.update_registry(
                key=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("key"),
                value=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("value"),
                data=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("data"),
                reg_type=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("reg_type"))

            if not flag:
                self.log.error("Failed to stop the automatic download process from push install ")
                raise Exception("Failed to create a Registry Key")

            # Deleting the present SoftwareCache and preserving CACHE Status Valid
            self.sw_cache_helper.delete_cache()

            for client_machine in self.machine_objects:
                install_helper = InstallHelper(self.commcell, client_machine)
                job_install = install_helper.install_software(
                    client_computers=[install_helper.client_host],
                    features=['FILE_SYSTEM', 'MEDIA_AGENT'])

                if job_install.wait_for_completion(5):
                    raise Exception("Software installed when the specific OS did not exist in the SW Cache")

                job_status = job_install.delay_reason
                if installer_messages.QINSTALL_PKG_INFO_MISSING not in job_status:
                    self.log.error("Job Failed due to some other reason than the expected one.")
                    raise Exception(job_status)

                self.log.info("JobFailingReason:%s", job_status)
            # Updating the registry to download from the Install job
            self.cs_machine.remove_registry(
                key=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("key"),
                value=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("value"))

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED
