# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

"""
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import config, constants
from AutomationUtils.machine import Machine
from Install import installer_constants, installer_messages
from Install.install_validator import InstallValidator


class TestCase(CVTestCase):
    """Negative Testcase : Push updates when the cache status is invalid."""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Push updates when the cache status is invalid."
        self.config_json = None
        self.cs_machine = None
        self.sw_cache_helper = None

    def setup(self):
        """Initializes pre-requisites for this test case"""
        self.config_json = config.get_config()
        self.cs_machine = Machine(machine_name=self.commcell.commserv_hostname,
                                  commcell_object=self.commcell)
        self.sw_cache_helper = self.commcell.commserv_cache

    def run(self):
        """Main function for test case execution"""
        try:
            windows_client = self.commcell.clients.get(self.config_json.Install.windows_client.machine_host)
            unix_client = self.commcell.clients.get(self.config_json.Install.unix_client.machine_host)
            cs_clients = [windows_client, unix_client]
            flag = self.cs_machine.update_registry(
                key=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("key"),
                value=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("value"),
                data=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("data"),
                reg_type=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("reg_type"))
            if not flag:
                self.log.error("Failed to stop the automatic download process from push install ")
                raise Exception("Failed to create a Registry Key")

            # Deleting the present SoftwareCache
            self.sw_cache_helper.delete_cache()
            self.sw_cache_helper.commit_cache()

            for client_machine in cs_clients:
                job = client_machine.push_servicepack_and_hotfix()

                if job.wait_for_completion(10):
                    raise Exception("Packages successfully installed on the machine even when the cache is invalid")

                job_status = job.delay_reason

                if installer_messages.QINSTALL_PKG_INFO_MISSING not in job_status:
                    self.log.error("Job Failed due to some other reason than the expected one.")
                    raise Exception(job_status)

                self.log.info("JobFailingReason:%s", job_status)

            self.cs_machine.remove_registry(
                key=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("key"),
                value=installer_constants.DO_NOT_DOWNLOAD_FROM_INSTALL_JOB.get("value"))
            for client_machine in cs_clients:
                job = client_machine.push_servicepack_and_hotfix()
                if job.wait_for_completion():
                    self.log.info("Packages successfully installed on the client")
                    install_validation = InstallValidator(client_machine.client_hostname, self)
                    install_validation.validate_baseline()
                    install_validation.validate_services()
                    install_validation.validate_sp_version()

                else:
                    job_status = job.delay_reason
                    self.log.error("Failed to Push Install packages to the client: %s" % client_machine.client_name)
                    raise Exception(job_status)

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED
