# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

"""
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from Install.install_validator import InstallValidator
from Install import installer_messages
from Install.install_helper import InstallHelper


class TestCase(CVTestCase):
    """Negative Testcase : Push updates to existing client which is not reachable"""

    def __init__(self):
        """Initializes tset case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Push updates to existing client which is not reachable"
        self.machine_obj = None

    def setup(self):
        """Initializes pre-requisites for this test case"""
        install_helper = InstallHelper(self.commcell)
        self.machine_obj = install_helper.get_machine_objects()

    def run(self):
        """Main function for test case execution"""
        try:
            cs_clients = {}
            cs_clients.update([(self.commcell.clients.get(self.machine_obj[0].machine_name), self.machine_obj[0]),
                               (self.commcell.clients.get(self.machine_obj[1].machine_name), self.machine_obj[1])])
            for client_obj, machine_obj in cs_clients.items():
                if client_obj.is_ready:
                    client_obj.stop_service("GxCVD(Instance001)")

                self.log.info("Pushing upgrades to the client: {0}".format(client_obj.client_name))
                job = client_obj.push_servicepack_and_hotfix()
                if job.wait_for_completion():
                    raise Exception("Failed to make the client unreachable")

                job_status = job.delay_reason
                if installer_messages.QUPDATE_UNREACHABLE_CLIENT not in job_status:
                    self.log.error("Job Failed due to some other reason than the expected one.")
                    raise Exception(job_status)

                self.log.info("JobFailingReason:%s", job_status)
                install_helper = InstallHelper(self.commcell, machine_obj)
                install_helper.restart_services(client_obj)

                if client_obj.is_ready:
                    job = job.resubmit()
                    if job.wait_for_completion(5):
                        install_validation = InstallValidator(client_obj.client_hostname, self)
                        install_validation.validate_baseline()
                        install_validation.validate_services()
                        install_validation.validate_sp_version()
                        self.log.info("Packages successfully installed on client machine")
                    else:
                        job_status = job.delay_reason
                        self.log.error("JobFailingReason:%s", job_status)
                        raise Exception("Failed to Install packages")
                else:
                    raise Exception("Failed to start services on the client")

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED
