# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

"""
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from Install import installer_messages
from Install.install_helper import InstallHelper


class TestCase(CVTestCase):
    """Negative Testcase : Push install a client with the wrong credentials"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = "Negative Scenario - Push install a client with the wrong credentials"
        self.machine_obj = None

    def setup(self):
        """Initializes pre-requisites for this test case"""
        install_helper = InstallHelper(self.commcell)
        self.machine_obj = install_helper.get_machine_objects()

    def run(self):
        """Main function for test case execution"""
        try:
            for platform in self.machine_obj:
                install_helper = InstallHelper(self.commcell, platform)
                job_with_wrong_credentials = install_helper.install_software(
                    client_computers=[install_helper.client_host],
                    features=['FILE_SYSTEM', 'MEDIA_AGENT'],
                    username='WrongDomainName\\WrongUsername',
                    password="WrongPassword")

                if job_with_wrong_credentials.wait_for_completion(5):
                    raise Exception("{0} client is marked as installed even with wrong credentials"
                                    .format(install_helper.client_host))

                job_status = job_with_wrong_credentials.delay_reason
                if not (installer_messages.QINSTALL_ERROR_ACCESS_REMOTE_REG in job_status or
                        installer_messages.QINSTALL_ERROR_LOGON in job_status):
                    self.log.error("Job Failed due to some other reason than the expected one.")
                    raise Exception(job_status)

                self.log.info("JobFailingReason:%s", job_status)

        except Exception as exp:
            self.log.error("Failed with an error: %s", exp)
            self.result_string = str(exp)
            self.status = constants.FAILED
