# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

Verify if backups run with valid/invalid credentials

TestCase:
    __init__()                  --  Initializes the TestCase class

    setup()                     --  All testcase objects are initializes in this method

    run()                       --  Contains the core testcase logic and it is the one executed

"""

from AutomationUtils.cvtestcase import CVTestCase
from Web.Common.cvbrowser import BrowserFactory
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.FileServerPages.file_servers import FileServers
from Web.AdminConsole.FileServerPages.fsagent import FsAgent, FsSubclient
from Web.AdminConsole.FileServerPages.fssubclientdetails import FsSubclientDetails
from Reports.utils import TestCaseUtils
from FileSystem.FSUtils.fshelper import FSHelper


class TestCase(CVTestCase):
    """Initiates test case."""

    def __init__(self):
        """Initializes test case class object"""

        super(TestCase, self).__init__()
        self.name = "Setting Pre/Post commands from command center"
        self.product = self.products_list.FILESYSTEM
        self.feature = self.features_list.ADMINCONSOLE

        self.tcinputs = {
            "ClientName": None,
            "BackupsetName": None,
            "SubclientName": None,
            "PreScanProcess": None,
            "PostScanProcess": None,
            "PreBackupProcess": None,
            "PostBackupProcess": None,
        }

    def setup(self):
        """ Testcase objects are initializes in this method"""

        self.utils = TestCaseUtils(self)

    def run(self):

        try:
            self.log.info("Started executing %s testcase", self.id)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(username=self.inputJSONnode['commcell']['commcellUsername'],
                                     password=self.inputJSONnode['commcell']['commcellPassword'])
            self.fs_agent_obj = FsAgent(self.admin_console)
            self.fssubclient_obj = FsSubclient(self.admin_console)
            self.subclient_obj = FsSubclientDetails(self.admin_console)
            self.file_servers = FileServers(self.admin_console)
            self.navigator = self.admin_console.navigator


            self.navigator.navigate_to_file_servers()

            self.file_servers.access_server(self.tcinputs['ClientName'])

            self.fssubclient_obj.access_subclient(self.tcinputs['BackupsetName'], self.tcinputs['SubclientName'])

            self.subclient_obj.set_pre_backup_command(self.tcinputs['PreBackupProcess'])

            self.subclient_obj.set_post_backup_command(self.tcinputs['PostBackupProcess'])

            self.subclient_obj.set_pre_post_advanced(pre_scan_process=self.tcinputs['PreScanProcess'],
                                                     post_scan_process=self.tcinputs['PostScanProcess'])

            self.helper = FSHelper(self)
            FSHelper.populate_tc_inputs(self, mandatory=False)

            commands_from_inputs = {"pre_scan_command": self.tcinputs['PreScanProcess'],
                                    "post_scan_command": self.tcinputs['PostScanProcess'],
                                    "pre_backup_command": self.tcinputs['PreBackupProcess'],
                                    "post_backup_command": self.tcinputs['PostBackupProcess']}

            self.subclient.refresh()
            self.helper.validate_pre_post_commands(commands_from_inputs)

            commands_from_inputs = {"pre_scan_command": self.tcinputs['PostScanProcess'],
                                    "post_scan_command": self.tcinputs['PreScanProcess'],
                                    "pre_backup_command": self.tcinputs['PostBackupProcess'],
                                    "post_backup_command": self.tcinputs['PreBackupProcess']}

            self.subclient_obj.set_pre_backup_command(self.tcinputs['PostBackupProcess'])

            self.subclient_obj.set_post_backup_command(self.tcinputs['PreBackupProcess'])

            self.subclient_obj.set_pre_post_advanced(pre_scan_process=self.tcinputs['PostScanProcess'],
                                                     post_scan_process=self.tcinputs['PreScanProcess'])

            self.subclient.refresh()
            self.helper.validate_pre_post_commands(commands_from_inputs)

            self.subclient_obj.clear_pre_post_commands(input_id="preBackupCommand")
            self.subclient_obj.clear_pre_post_commands(input_id="postBackupCommand")
            self.subclient_obj.clear_pre_post_commands(input_id="preScanCommand")
            self.subclient_obj.clear_pre_post_commands(input_id="postScanCommand")

            commands_from_inputs = {"pre_scan_command": '', "post_scan_command": '', "pre_backup_command": '',
                                    "post_backup_command": ''}

            self.subclient.refresh()
            self.helper.validate_pre_post_commands(commands_from_inputs)

        except Exception as exp:
            self.utils.handle_testcase_exception(exp)
            self.log.info(str(exp))

        finally:

            self.browser.close()
