# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    setup()         --  sets up the variables required for running the testcase

    run()           --  run function of this test case

    teardown()      --  tears down the things created for running the testcase

"""

from AutomationUtils.cvtestcase import CVTestCase
from Web.Common.page_object import handle_testcase_exception
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.Helper.commcell_helper import CommcellHelper


class TestCase(CVTestCase):
    """Basic Acceptance test for commcell page"""

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Basic Acceptance test for commcell page"
        self.browser = None
        self.admin_console = None
        self.navigator = None
        self.commcell_obj = None
        self._new_settings = None

    def setup(self):
        self.browser = BrowserFactory().create_browser_object()
        self.browser.open()
        self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
        self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                 self.inputJSONnode['commcell']['commcellPassword'],
                                 stay_logged_in=True)
        self.navigator = self.admin_console.navigator
        self._new_settings = ['Activity control',
                              {'General': {'Use UPN instead of e-mail': 'ON'}},
                              'Privacy']

    def run(self):
        try:
            self.navigator.navigate_to_commcell()
            self.commcell_obj = CommcellHelper(self.admin_console, self.commcell)
            self.commcell_obj.extract_and_validate(save_initial=True)
            self.commcell_obj.edit_details(self._new_settings)
            self.commcell_obj.extract_and_validate(edited=True)
        except Exception as err:
            handle_testcase_exception(self, err)

    def tear_down(self):
        try:
            self.commcell_obj.edit_details(self._new_settings, True)
        except Exception as err:
            handle_testcase_exception(self, err)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
