# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

from AutomationUtils.cvtestcase import CVTestCase
from Web.AdminConsole.AdminConsolePages.Navigation import Navigation
from Web.AdminConsole.adminconsole import AdminConsole

from Web.Common.cvbrowser import (
    BrowserFactory,
    Browser
)
from Web.Common.exceptions import CVTestCaseInitFailure
from Web.Common.page_object import TestStep, handle_testcase_exception


class TestCase(CVTestCase):
    """ TestCase class used to execute the test case from here."""
    test_step = TestStep()

    def __init__(self):
        super(TestCase, self).__init__()
        self.name = "Basic aceptance test case for Navigation Preferences"
        self.show_to_user = True
        self.browser = None
        self.driver = None
        self.adminconsole = None
        self.nav_pref = None
        self.c_names = None
        self.t_names = None
        self.tcinputs = {
            "companyName": None
        }

    def init_tc(self):
        """ Initial configuration for the test case. """
        try:
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.driver = self.browser.driver
            self.adminconsole = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.adminconsole.login(self.inputJSONnode['commcell']['commcellUsername'],
                                    self.inputJSONnode['commcell']['commcellPassword'])
            self.adminconsole.navigator.navigate_to_navigation()
            self.nav_pref = Navigation(self.adminconsole)

        except Exception as exception:
            raise CVTestCaseInitFailure(exception)from exception

    @test_step
    def admin_logout_login(self):
        """ Logs out and logs back in admin console"""
        self.adminconsole.logout()
        self.adminconsole.login(self.inputJSONnode['commcell']['commcellUsername'],
                                self.inputJSONnode['commcell']['commcellPassword'])

    @test_step
    def tenant_switch(self):
        """ Switches the operator to the company """
        self.adminconsole.navigator.switch_company_as_operator(self.tcinputs['companyName'])

    @test_step
    def reset_to_default(self):
        """ Resets all the entities to Default values of Commcell admin """
        self.admin_logout_login()
        self.adminconsole.navigator.navigate_to_navigation()
        self.nav_pref.reset_to_default()

    @test_step
    def validate_changes(self, flag_1=False, flag_2=False, flag_3=False, flag_4=False):
        """ Validates the changed values from the navigation panel """
        if flag_1:
            if flag_3 and self.c_names:
                for entity in self.c_names:
                    if not self.adminconsole.navigator.check_if_element_exists(entity):
                        continue
                    else:
                        raise Exception(f"Validation Failed, Updated entity {entity} is still visible")
            if flag_4 and self.t_names:
                for entity in self.t_names:
                    if not self.adminconsole.navigator.check_if_element_exists(entity):
                        continue
                    else:
                        raise Exception(f"Validation Failed, Updated entity {entity} is still visible")
        if flag_2:
            if flag_3 and self.c_names:
                for entity in self.c_names:
                    if self.adminconsole.navigator.check_if_element_exists(entity):
                        continue
                    else:
                        raise Exception(f"Validation Failed, after resetting to default, "
                                        f"entity {entity} is not visible")
            if flag_4 and self.t_names:
                for entity in self.t_names:
                    if self.adminconsole.navigator.check_if_element_exists(entity):
                        continue
                    else:
                        raise Exception(f"Validation Failed, after resetting to default, "
                                        f"entity {entity} is not visible")

    def run(self):
        try:
            self.init_tc()
            self.c_names, self.t_names = self.nav_pref.update_navigation()
            self.admin_logout_login()
            self.validate_changes(flag_1=True, flag_3=True)
            self.tenant_switch()
            self.validate_changes(flag_1=True, flag_4=True)
            self.reset_to_default()
            self.admin_logout_login()
            self.validate_changes(flag_2=True, flag_3=True)
            self.tenant_switch()
            self.validate_changes(flag_2=True, flag_4=True)
        except Exception as exp:
            self.reset_to_default()
            handle_testcase_exception(self, exp)
        finally:
            AdminConsole.logout_silently(self.adminconsole)
            Browser.close_silently(self.browser)
