# -*- coding: utf-8 -*-
# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()                   --  initialize TestCase class

    init_tc()                    --  initialize TestCase class

    run()                        --  Main function for test case execution
"""
import re, random
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils.machine import Machine
from Reports.utils import TestCaseUtils
from Web.Common.page_object import TestStep
from Web.Common.exceptions import CVTestCaseInitFailure, CVTestStepFailure
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.Helper.file_servers_helper import FileServersMain
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.AdminConsolePages.view_logs import ViewLogs


class TestCase(CVTestCase):
    """Test case to verify view log file feature acceptance"""
    test_step = TestStep()

    def __init__(self):
        """Init method for test case class"""
        super(TestCase, self).__init__()
        self.name = "Admin console : View Logs Acceptance"
        self.browser = None
        self.admin_console = None
        self._utils = None
        self._file_servers = None
        self._view_logs = None
        self.log_data_from_client = ''
        self.log_data = ''
        self.client_machine = None
        self.tcinputs = {
            "log_name": None
        }

    def init_tc(self):
        """Initialize browser and redirect to page"""
        try:
            self._utils = TestCaseUtils(self)
            self.client_machine = Machine(self.client)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(
                self.inputJSONnode['commcell']['commcellUsername'],
                self.inputJSONnode['commcell']['commcellPassword']
            )
            self._file_servers = FileServersMain(self.admin_console, self.commcell)
            self._view_logs = ViewLogs(self.admin_console)
        except Exception as _exception:
            raise CVTestCaseInitFailure(_exception) from _exception

    def run(self):
        """Main function for test case execution"""
        try:
            self.init_tc()
            self._file_servers.view_live_logs(self.client.client_name, self.tcinputs['log_name'])
            log_data = self._view_logs.get_log_data().strip().splitlines()
            search_filters = re.match("^([+-]?[0-9]+)(( )|(    ))+([+-]?[0]?[xX]?[0-9A-Fa-f]+)(( )|(    ))+"
                                      "((1[0-2]|0?[1-9])/([12][0-9]|[3][01]|0?[1-9]))(( )|(    ))+(([0-2]?"
                                      "[0-9]):([0-5]?[0-9]):([0-5]?[0-9]))(( )|(    ))+([^     ]+)(( )|(    ))+(.*)",
                                      log_data[-1]).groups()
            search_filters = [x for x in search_filters if x and x != ' ']
            search_string = [x for x in search_filters[-1].split(" ") if x]
            filter_dict = {
                'processId': search_filters[0],
                'threadId': search_filters[1],
                'includeString': random.choice(search_string),
                'excludeString': random.choice(search_string)
            }
            status = {}
            for filter_name, filter_value in filter_dict.items():
                self._view_logs.set_filters({filter_name: filter_value}, True)
                log_data = [data.lower() for data in self._view_logs.get_log_data().strip().splitlines() if
                            len(data.split(" ")) > 1]
                lines_wo_filter = [data for data in log_data if filter_value.lower() not in data]
                if filter_name == 'excludeString':
                    if not len(log_data) == len(lines_wo_filter):
                        status[filter_name] = lines_wo_filter
                elif lines_wo_filter:
                    status[filter_name] = lines_wo_filter

            if status:
                raise CVTestStepFailure("Filter not set for %s"%status)

        except Exception as err:
            self._utils.handle_testcase_exception(err)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
