# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

    tear_down()     --  tear down function of this test case

"""
from Application.Sharepoint.sharepoint_online import SharePointOnline
from AutomationUtils import constants
from AutomationUtils.cvtestcase import CVTestCase


class TestCase(CVTestCase):
    """Class for executing the test case of  Office365- SharePoint Online Pseudo Client creation"""

    def __init__(self):
        """Initializes test case class object

            Properties to be initialized:

                name            (str)       --  name of this test case

                tcinputs        (dict)      --  test case inputs with input name as dict key
                                                and value as input type

        """
        super(TestCase, self).__init__()
        self.name = "Office365- SharePoint Online- Pseudo Client Creation- General"
        self.sp_client_object = None
        self.tcinputs = {
            "PseudoClientName": None,
            "ServerPlanName": None,
            "IndexServer": None,
            "AccessNodes": None,
            "GlobalAdministrator": None,
            "GlobalAdministrator Password": None,
            "AzureAppId": None,
            "AzureAppKeyValue": None,
            "AzureDirectoryId": None
        }

    def setup(self):
        """Setup function of this test case"""
        self.log.info('Creating SharePoint client object.')
        self.sp_client_object = SharePointOnline(self)

        self.sp_client_object.pseudo_client_name = self.tcinputs.get("PseudoClientName")
        self.sp_client_object.server_plan = self.tcinputs.get('ServerPlanName')

        # Infrastructure details
        self.sp_client_object.index_server = self.tcinputs.get('IndexServer')
        self.sp_client_object.access_nodes_list = self.tcinputs.get('AccessNodes')

        # SharePoint details
        self.sp_client_object.global_administrator = self.tcinputs.get('GlobalAdministrator')
        self.sp_client_object.global_administrator_password = self.tcinputs.get('GlobalAdministrator Password')

        # Azure Details
        self.sp_client_object.azure_app_id = self.tcinputs.get('AzureAppId', "")
        self.sp_client_object.azure_app_key_id = self.tcinputs.get('AzureAppKeyValue', "")
        self.sp_client_object.azure_directory_id = self.tcinputs.get('AzureDirectoryId', "")

        self.log.info('SharePoint client object created.')

    def run(self):
        """Run function of this test case"""
        try:
            self.sp_client_object.cvoperations.add_share_point_pseudo_client()
            self.log.info("Pseudo Client has been created successfully")
            self.sp_client_object.cvoperations.validate_client_creation()
            self.log.info("Pseudo Client validation is done successfully")
            self.sp_client_object.cvoperations.delete_share_point_pseudo_client\
                (self.sp_client_object.pseudo_client_name)
            self.log.info("Pseudo Client has been deleted successfully")
        except Exception as exp:
            self.log.error('Failed to execute test case with error: %s', exp)
            self.result_string = str(exp)
            self.status = constants.FAILED

