# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:

    __init__()      --  initialize TestCase class

    setup()         --  setup function of this test case

    run()           --  run function of this test case

    tear_down()     --  tear down function of this test case

Inputs:

    DeploymentClientName    --  the client to uninstall software on

"""

from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils import constants
from Install.install_helper import InstallHelper
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.AdminConsole.Helper.DeploymentHelper import DeploymentHelper
from Web.AdminConsole.adminconsole import AdminConsole


class TestCase(CVTestCase):
    """Class for retiring client from Admin Console"""

    def __init__(self):
        """Initializes test case class object"""
        super(TestCase, self).__init__()
        self.name = ("Retire Client from Admin Console")
        self.factory = None
        self.browser = None
        self.driver = None
        self.login_obj = None
        self.admin_console = None
        self.deployment_helper = None
        self.tcinputs = {
            "DeploymentClientName": None
        }
        self.machine_objects = None
        self.unix_machine = None

    def setup(self):
        """Initializes pre-requisites for this test case"""
        self.factory = BrowserFactory()
        self.browser = self.factory.create_browser_object()
        self.browser.open()
        self.driver = self.browser.driver
        self.admin_console = AdminConsole(self.browser, self.inputJSONnode['commcell']['webconsoleHostname'])
        self.admin_console.login(self.inputJSONnode['commcell']['commcellUsername'],
                                 self.inputJSONnode['commcell']['commcellPassword'],
                                 stay_logged_in=True)
        self.deployment_helper = DeploymentHelper(self, self.admin_console)
        install_helper = InstallHelper(self.commcell)
        self.machine_objects = install_helper.get_machine_objects()
        self.unix_machine = install_helper.get_machine_objects(2)[0]

    def run(self):
        """Main function for test case execution"""

        try:
            self.install_helper = InstallHelper(self.commcell, self.unix_machine)
            if not self.commcell.clients.has_client(self.install_helper.client_host):
                self.log.info("Creating {0} client".format(self.unix_machine.os_info))
                job = self.install_helper.install_software()

                if not job.wait_for_completion():
                    raise Exception("{0} Client installation Failed".format(self.unix_machine.os_info))

            self.commcell.clients.refresh()

            self.deployment_helper.retire_server(
                server_name=self.tcinputs.get('DeploymentClientName')
            )

        except Exception as exp:
            self.log.error('Failed with error: %s', exp)
            self.result_string = str(exp)
            self.status = constants.FAILED

        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)

