# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case
TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()                                          -- initialize TestCase class
    init_tc()                                           -- initialize pre-requisites
    run_send_log()                                      -- To run sendLogs job
    all_received__send_log_bundle()                     -- checking all received send log
                                                           chunck size
    verify_data_collected_from_all_send_log_bundle()    -- checking whether extracted file
                                                           contain data from
    run()                                               -- run function of this test case

Input Example:

    "testCases":
            {
                "55122":
                        {
                            "map_path": "\\\\eng.commvault.com\\celogs"
                        }
            }

"""
import time
import os
from AutomationUtils.machine import Machine
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils.config import get_config
from Web.AdminConsole.AdminConsolePages.Commcell import Commcell
from Web.AdminConsole.AdminConsolePages.send_logs import SendLogs
from Web.AdminConsole.adminconsole import AdminConsole
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.Common.page_object import TestStep
from Web.Common.exceptions import CVTestCaseInitFailure, CVTestStepFailure
from Web.Common.page_object import handle_testcase_exception
from cvpysdk.license import LicenseDetails
from Reports.SendLog.utils import SendLogUtils

_STORE_CONFIG = get_config()
class TestCase(CVTestCase):
    """Class for executing send log files with split file option test case"""
    test_step = TestStep()

    def __init__(self):
        """Initializes test case class object

            Properties to be initialized:

                name            (str)       --  send log files with split file option


        """
        super(TestCase, self).__init__()
        self.browser = None
        self.admin_console = None
        self.send_log = None
        self.job_id = None
        self.commcell_id = None
        self.file_size = 0
        self.count = 0
        self.machine = None
        self.path = None
        self.commcell_name = None
        self.navigator = None
        self.send_log_utils = None
        self.commserv_client = None
        self.tcinputs = {
            "send_logs_path": None
        }
        self.name = " sendlogfiles with split file option"

    def init_tc(self):
        """
            Initial configuration for the test case
            """
        try:
            self.log.info("Initializing pre-requisites")
            licence = LicenseDetails(self.commcell)
            self.commcell_id = licence.commcell_id_hex
            self.commcell_name = self.commcell.commserv_name
            self.commserv_client = self.commcell.commserv_client
            self.machine = Machine(self.commserv_client)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(self.inputJSONnode['commcell']["commcellUsername"],
                                     self.inputJSONnode['commcell']["commcellPassword"])
            self.send_log_utils = SendLogUtils(self, self.machine)
            navigator = self.admin_console.navigator
            navigator.navigate_to_commcell()
        except Exception as exception:
            raise CVTestCaseInitFailure(exception) from exception

    def run_send_log(self):
        """Running SendLog job"""
        comm_cell = Commcell(self.admin_console)
        comm_cell.access_sendlogs()
        send_log = SendLogs(self.admin_console)
        advanced_list = send_log.Advancedlist
        send_log.deselect_advanced(advanced_list=[advanced_list.SCRUB_LOGFILES])
        info_list = send_log.Informationlist
        send_log.select_information(information_list=[info_list.CSDB, info_list.OS_LOGS,
                                                      info_list.LOGS])
        send_log.select_advanced(advanced_list=[advanced_list.DB_LOGS, advanced_list.JOBS_RESULTS])
        self.job_id = send_log.submit()
        job_obj = self.commcell.job_controller.get(self.job_id)
        job_status = job_obj.wait_for_completion()
        if not job_status:
            raise CVTestStepFailure(
                f"Send log job id [{self.job_id}] failed"
            )

    @test_step
    def received_all_send_log_bundle(self):
        """ verifying all received send log bundle with extension 7z.001, 7z.002, ...... """
        file = self.machine.get_files_in_path(folder_path=self.path)
        file_name_suffix = self.job_id + ".7z.00"
        file_name_prefix = "sendLogFiles"
        for file_var in file:
            if file_name_suffix in file_var and file_name_prefix in file_var:
                file_size = self.machine.get_file_size(file_path=file_var)
                self.log.info(f"[{file_var}] present at location : [{self.path}] file size : [{file_size}]")
                if file_size > 512:
                    raise CVTestStepFailure(
                        f" Chunked File Size is greater than 512 MB, file name {file_var}"
                    )
                self.count = self.count + 1
                if file_var.find(".7z.001") > 0:
                    self.path = file_var
        if self.count == 0:
            raise CVTestStepFailure(
                f" send log  file not present  with chunking {file_name_suffix} "
            )

    def run(self):
        try:
            self.init_tc()
            self.run_send_log()
            self.log.info(
                'Waiting for 20 sec to check file present '
                + ' for send log job id' + self.job_id)
            time.sleep(20)
            unc_user = _STORE_CONFIG.Cloud.username
            unc_password = _STORE_CONFIG.Cloud.password
            command = 'net use %s %s /user:%s /persistent:yes' % (
                self.tcinputs['send_logs_path'], unc_password, unc_user)
            retCode = os.system(command)
            if retCode != 0:
                self.log.error(
                    "Error executing net use remote command - retcode :: " + str(retCode))
                self.log.error(
                    "Copy to local folder instead of UNC path as 'net use' command failed to"
                    " initialize")
            else:
                self.log.info('Successfully executed net use remote command')
            self.path = os.path.join(self.tcinputs['send_logs_path'], self.commcell_id)
            self.received_all_send_log_bundle()
        except Exception as exp:
            handle_testcase_exception(self, exp)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
