# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""
Notes :
1>   Before executing this test case map \\eng\\celogs as "Y:\" in the commserver vm
2>   For email verification give email and its credential and server name in config.json :


Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()                       --  initialize TestCase class
    init_tc()                        --  initial configuration for this test case
    run_send_log()                   -- To run sendLogs job
    extract_send_logs_files()        -- To copy send log file from network location
                                        to local drive and wrapping it
    verify_commvault_logs()          -- to unzip and verify different send log file
    verify_machine_os_logs()         -- to verify different machine and os send log file
    run()                            --  run function of this test case

Input Example:

    "testCases":
            {
                "55117":
                 {
                     "email_id": "your_email_id@commvault.com",
                     "map_path": "\\\\eng.commvault.com\\celogs"
                 }
            }


"""
import time
import os
from AutomationUtils.machine import Machine
from Web.Common.page_object import handle_testcase_exception
from AutomationUtils.cvtestcase import CVTestCase
from AutomationUtils.config import get_config
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.Common.page_object import TestStep
from Web.AdminConsole.adminconsole import AdminConsole
from Web.AdminConsole.AdminConsolePages.Commcell import Commcell
from Web.AdminConsole.AdminConsolePages.send_logs import SendLogs
from Web.Common.exceptions import CVTestCaseInitFailure, CVTestStepFailure
from cvpysdk.license import LicenseDetails
from Reports.SendLog.utils import SendLogUtils


_STORE_CONFIG = get_config()
class TestCase(CVTestCase):
    """This test case verifies basic sendlogfiles feature"""
    test_step = TestStep()

    def __init__(self):
        """Initializes test case class object

            Properties to be initialized:

                name            (str)       --  name of this test case

                tcinputs        (dict)      --  test case inputs with input name as dict key
                                                and value as input type

        """
        super(TestCase, self).__init__()
        self.browser = None
        self.admin_console = None
        self.send_log = None
        self.info_list = None
        self.jobid = None
        self.utils = None
        self.commcell_id = None
        self.commcell_name = None
        self.download_directory = None
        self.machine = None
        self.commserv_client = None
        self.path = None
        self.download_directory = None
        self.send_log_utils = None
        self.name = "Acceptance of Sendlogs for logs collection"
        self.tcinputs = {
            "send_logs_path": None,
            "email_id": None
        }

    def init_tc(self):
        """
            Initial configuration for the test case
            """
        try:
            self.log.info("Initializing pre-requisites")
            self.commserv_client = self.commcell.commserv_client
            self.machine = Machine(self.commserv_client)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.admin_console = AdminConsole(self.browser, self.commcell.webconsole_hostname)
            self.admin_console.login(self.inputJSONnode['commcell']["commcellUsername"],
                                     self.inputJSONnode['commcell']["commcellPassword"])

            self.send_log_utils = SendLogUtils(self, self.machine)
            self.download_directory = self.send_log_utils.create_directory_for_given_path("TC55117")
            navigator = self.admin_console.navigator
            navigator.navigate_to_commcell()
            licence = LicenseDetails(self.commcell)
            self.commcell_id = licence.commcell_id_hex
            self.commcell_name = self.commcell.commserv_name
            comm_cell = Commcell(self.admin_console)
            comm_cell.access_sendlogs()
            self.send_log = SendLogs(self.admin_console)
            self.info_list = self.send_log.Informationlist
        except Exception as exception:
            raise CVTestCaseInitFailure(exception) from exception

    @test_step
    def run_send_log(self):
        """Running SendLog job"""
        self.send_log.email([self.tcinputs['email_id']])
        self.jobid = self.send_log.submit()
        job_obj = self.commcell.job_controller.get(self.jobid)
        job_status = job_obj.wait_for_completion()
        if not job_status:
            raise CVTestStepFailure(
                f"Send log job id [{self.jobid}] failed"
            )

    @test_step
    def extract_send_logs_files(self):
        """ To copy send log from network location to local
            drive and unzip send log content in local drive"""
        self.log.info(f"Send Log content copying to {self.download_directory}")
        self.machine.copy_from_local(local_path=self.path, remote_path=self.download_directory)
        temp = self.path.find('sendLogFiles')
        self.path = self.path[int(temp):]
        self.path = os.path.join(self.download_directory, self.path)
        self.path = self.send_log_utils.unzip_send_log_file(self.commserv_client, self.path)

    @test_step
    def verify_commvault_logs(self):
        """Verifying commvault send logs """
        self.log.info('Unzipping file and Verifying comm server logs:'
                      ' cvd.log, evmgrs.log jobmgr.log, '
                      'SystemInfo_ ')
        temp = self.commcell_name + ".7z"
        self.path = os.path.join(self.path, temp)
        self.path = self.send_log_utils.unzip_send_log_file(self.commserv_client, self.path)
        self.send_log_utils.log_file_verification_with_full_name(self.path,
                                                                 ['CVD.log', 'EvMgrS.log', 'JobManager.log',
                                                                  'Certificates.7z'])
        self.path = self.send_log_utils.log_file_verification_with_partial_name(self.path, 'SystemInfo_')

    @test_step
    def verify_machine_os_logs(self):
        """Verifying machine and os logs"""
        self.log.info("Verifying Machine logs and os logs")
        self.send_log_utils.verify_machine_logs_and_os_logs(self.commserv_client, self.path,
                                                            ['Application.evtx', 'Application.log', 'system.evtx',
                                                             'system.log'], ['_SystemConfig'])

    def run(self):
        """Run function of this test case to Run backup """
        try:
            self.init_tc()
            self.run_send_log()
            self.log.info(f'Waiting for 1 minute to check email for send log job id {self.jobid}')
            time.sleep(60)
            self.send_log_utils.verify_email(self.download_directory)
            self.log.info(f"Waiting for 15 minute to check file present at "
                          f"network location for send log job id {self.jobid}")
            time.sleep(600)
            unc_user = _STORE_CONFIG.Cloud.username
            unc_password = _STORE_CONFIG.Cloud.password
            command = 'net use %s %s /user:%s /persistent:yes' % (
                            self.tcinputs['send_logs_path'], unc_password, unc_user)
            retCode = os.system(command)
            if retCode != 0:
                self.log.error(
                    "Error executing net use remote command - retcode :: " + str(retCode))
                self.log.error(
                    "Copy to local folder instead of UNC path as 'net use' command failed to initialize")
                self.UNCCopyNetUseCommand = False
            else:
                self.log.info('Successfully executed net use remote command')
                self.UNCCopyNetUseCommand = True
            path = os.path.join(self.tcinputs['send_logs_path'], self.commcell_id)
            self.path = self.send_log_utils.is_send_log_bundle_exist(file_path=path,
                                                                     job_id=self.jobid)
            self.extract_send_logs_files()
            self.verify_commvault_logs()
            self.verify_machine_os_logs()
            self.machine.remove_directory(self.download_directory)
        except Exception as exp:
            handle_testcase_exception(self, exp)
        finally:
            AdminConsole.logout_silently(self.admin_console)
            Browser.close_silently(self.browser)
