# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

""""Main file for executing this test case

TestCase is the only class defined in this file.

TestCase: Class for executing this test case

TestCase:
    __init__()                                            --  initialize TestCase class
    init_tc()                                             --  Initialize pre-requisites
    run_cloud_troubleshooting_send_log()                   -- method for run cloud troubleshoot request
    check_troubleshoot_xml_exist()                         -- method for verify xml
    run()                                                 --  run function of this test case
Input Example:

    "testCases":
            {
                "55088":
                        {

                        }
            }


"""
import time
from Web.Common.page_object import handle_testcase_exception
from AutomationUtils.cvtestcase import CVTestCase
from Web.Common.page_object import TestStep
from Web.Common.cvbrowser import BrowserFactory, Browser
from Web.WebConsole.webconsole import WebConsole
from AutomationUtils.config import get_config
from Web.WebConsole.Reports.Troubleshooting.troubleshoot import CloudSendLog
from Web.AdminConsole.adminconsole import AdminConsole
from Web.Common.exceptions import CVTestCaseInitFailure, CVTestStepFailure
from Reports.metricsutils import MetricsServer
from cvpysdk.license import LicenseDetails


class TestCase(CVTestCase):
    """ remote troubleshooting from cloud """
    test_step = TestStep()

    def __init__(self):
        """Initializes test case class object

            Properties to be initialized:

                name            (str)       --  name of this test case

        """
        super(TestCase, self).__init__()
        self.name = "remote troubleshooting from cloud"
        self.browser = None
        self.web_console = None
        self.metrics_server = None
        self.request_id = None
        self.metrics_server = None
        self.cloud_send_log = None

    def init_tc(self):
        """
            Initial configuration for the test case
            """
        try:
            self.log.info("Initializing pre-requisites")
            _STORE_CONFIG = get_config()
            username = _STORE_CONFIG.Cloud.username
            password = _STORE_CONFIG.Cloud.password
            cloud_url = _STORE_CONFIG.Cloud.host_name
            if not username or not password:
                self.log.info("Cloud username and password are not configured in config.json")
                raise Exception("Cloud username and password are not configured. Please update "
                                "the username and password details under "
                                "<Automation_Path>/CoreUtils/Templates/template-config.json")
            self.metrics_server = MetricsServer(cloud_url, username, password)
            self.browser = BrowserFactory().create_browser_object()
            self.browser.open()
            self.web_console = WebConsole(self.browser, cloud_url)
            self.web_console.login(username, password)
            self.web_console.goto_troubleshooting()
        except Exception as exception:
            raise CVTestCaseInitFailure(exception) from exception

    @test_step
    def run_cloud_troubleshooting_send_log(self):
        """
                Method to run cloud troubleshooting request for send logs send_log
        """
        self.cloud_send_log = CloudSendLog(self.web_console)
        self.cloud_send_log.access_commcell(self.commcell.commserv_name)
        self.cloud_send_log.close_popup()
        self.cloud_send_log.submit()
        if self.cloud_send_log.is_request_submit_success() is False:
            raise CVTestStepFailure("Cloud troubleshooting request for send log  get failed ")
        self.log.info('Send Log  request submitted from cloud')

    @test_step
    def check_troubleshoot_xml_exist(self):
        """check request xml created in Troubleshoot directory"""
        self.log.info('Wait for 1 minute for xml creation in script folder')
        time.sleep(60)
        licence = LicenseDetails(self.commcell)
        request_id = self.cloud_send_log.get_request_id()
        path = self.metrics_server.get_troubleshoot_xml_name(request_id, licence.commcell_id_hex)
        if not self.metrics_server.metrics_machine.check_file_exists(file_path=path):
            raise CVTestStepFailure(
                f"Troubleshoot file not present at location  [{path}] failed"
            )
        self.log.info(f"Troubleshoot file available at {path}")

    def run(self):
        try:
            self.init_tc()
            self.run_cloud_troubleshooting_send_log()
            self.check_troubleshoot_xml_exist()
        except Exception as exp:
            handle_testcase_exception(self, exp)
        finally:
            AdminConsole.logout_silently(self.web_console)
            Browser.close_silently(self.browser)
